<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}
include_once '../classes/settings.php';
include_once '../classes/class_db.php';
$ObjDB = new class_settings();
$conn = $ObjDB->MyConnectDB();
$success = "";
$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = mysqli_real_escape_string($conn, $_POST['full_name']);
    $company = mysqli_real_escape_string($conn, $_POST['Company']);
    $category = mysqli_real_escape_string($conn, $_POST['category']);
    $brief_personal_desc = mysqli_real_escape_string($conn, $_POST['brief_personal_desc']);
    $brief_business_desc = mysqli_real_escape_string($conn, $_POST['brief_business_desc']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);
    $facebook_link = mysqli_real_escape_string($conn, $_POST['facebook_link']);
    $youtube_link = mysqli_real_escape_string($conn, $_POST['youtube_link']);
    $instagram_link = mysqli_real_escape_string($conn, $_POST['instagram_link']);
    $their_give = mysqli_real_escape_string($conn, $_POST['their_give']);
    $their_ask = mysqli_real_escape_string($conn, $_POST['their_ask']);
    $photo_name = "";
    if (isset($_FILES['photo']) && $_FILES['photo']['error'] !== UPLOAD_ERR_NO_FILE) {
        $file = $_FILES['photo'];
        if ($file['error'] === UPLOAD_ERR_OK) {
            $file_tmp = $file['tmp_name'];
            $file_name = basename($file['name']);
            $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
            $allowed = ['jpg', 'jpeg', 'png', 'gif'];

            if (!in_array($ext, $allowed)) {
                $error = "Invalid file type! Only JPG, JPEG, PNG, and GIF are allowed.";
            } elseif ($file['size'] > 5 * 1024 * 1024) {
                $error = "File too large! Maximum 5 MB allowed.";
            } else {
                $upload_dir = 'images/';
                if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

                $photo_name = time() . '_' . preg_replace("/[^A-Za-z0-9_.-]/", "_", $file_name);
                $upload_path = $upload_dir . $photo_name;

                if (!move_uploaded_file($file_tmp, $upload_path)) {
                    $error = "Failed to move uploaded file!";
                }
            }
        } else {
            $error = "Upload error! Code: " . $file['error'];
        }
    }
    if (empty($error)) {
        $query = "INSERT INTO bni_members_tbl (photo, full_name, Company, category, brief_personal_desc, brief_business_desc, address,facebook_link, youtube_link, instagram_link, their_give, their_ask, timestamp) VALUES  ('$photo_name', '$full_name', '$company', '$category', '$brief_personal_desc', '$brief_business_desc', '$address','$facebook_link', '$youtube_link', '$instagram_link', '$their_give', '$their_ask', NOW())";
         if (mysqli_query($conn, $query)) {
            $success = "Member added successfully!";
            $_POST = [];
        } else {
            $error = " Database error: " . mysqli_error($conn);
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Add Member</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<header class="bg-dark text-white p-3">
    <div class="container d-flex justify-content-between align-items-center">
        <h3>BNI Admin Dashboard</h3>
        <a href="admin_logout.php" class="btn btn-danger btn-sm">Logout</a>
    </div>
</header>
<div class="container mt-5">
    <div class="card shadow p-4">
        <h3 class="mb-3">Add New Member</h3>

        <?php if (!empty($success)) { ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php } ?>
        <?php if (!empty($error)) { ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php } ?>

        <form method="POST" enctype="multipart/form-data">

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Full Name</label>
                    <input type="text" name="full_name" class="form-control" required value="<?php echo isset($_POST['full_name']) ? $_POST['full_name'] : ''; ?>">
                </div>

                <div class="col-md-6 mb-3">
                    <label>Company</label>
                    <input type="text" name="Company" class="form-control" value="<?php echo isset($_POST['Company']) ? $_POST['Company'] : ''; ?>">
                </div>

                <div class="col-md-6 mb-3">
                    <label>Category</label>
                    <input type="text" name="category" class="form-control" value="<?php echo isset($_POST['category']) ? $_POST['category'] : ''; ?>">
                </div>

                <div class="col-md-6 mb-3">
                    <label>Photo</label>
                    <input type="file" name="photo" class="form-control">
                </div>

                <div class="col-md-12 mb-3">
                    <label>Brief Personal Description</label>
                    <textarea name="brief_personal_desc" class="form-control"><?php echo isset($_POST['brief_personal_desc']) ? $_POST['brief_personal_desc'] : ''; ?></textarea>
                </div>

                <div class="col-md-12 mb-3">
                    <label>Brief Business Description</label>
                    <textarea name="brief_business_desc" class="form-control"><?php echo isset($_POST['brief_business_desc']) ? $_POST['brief_business_desc'] : ''; ?></textarea>
                </div>

                <div class="col-md-12 mb-3">
                    <label>Address</label>
                    <textarea name="address" class="form-control"><?php echo isset($_POST['address']) ? $_POST['address'] : ''; ?></textarea>
                </div>

                <div class="col-md-4 mb-3">
                    <label>Facebook Link</label>
                    <input type="text" name="facebook_link" class="form-control" value="<?php echo isset($_POST['facebook_link']) ? $_POST['facebook_link'] : ''; ?>">
                </div>

                <div class="col-md-4 mb-3">
                    <label>YouTube Link</label>
                    <input type="text" name="youtube_link" class="form-control" value="<?php echo isset($_POST['youtube_link']) ? $_POST['youtube_link'] : ''; ?>">
                </div>

                <div class="col-md-4 mb-3">
                    <label>Instagram Link</label>
                    <input type="text" name="instagram_link" class="form-control" value="<?php echo isset($_POST['instagram_link']) ? $_POST['instagram_link'] : ''; ?>">
                </div>

                <div class="col-md-6 mb-3">
                    <label>Their Give</label>
                    <textarea name="their_give" class="form-control"><?php echo isset($_POST['their_give']) ? $_POST['their_give'] : ''; ?></textarea>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Their Ask</label>
                    <textarea name="their_ask" class="form-control"><?php echo isset($_POST['their_ask']) ? $_POST['their_ask'] : ''; ?></textarea>
                </div>
                <div class="col-md-12 text-end">
                    <button type="submit" class="btn btn-primary">Add Member</button>
                </div>
            </div>
        </form>
        <br/>
    </div>
        <br/>
        <br/>
</div>

</body>
</html>
