<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
header('Content-Type: application/json');
include_once 'classes/settings.php';
include_once 'classes/class_db.php';
$ObjDB = new class_settings();
$conn = $ObjDB->MyConnectDB();

if (!$conn) {
    http_response_code(500);
    echo json_encode(['error' => 'Database connection failed']);
    exit;
}
$query = "SELECT * FROM bni_members_tbl ORDER BY add_datetime ASC;";
$result = mysqli_query($conn, $query);

if (!$result) {
    http_response_code(500);
    echo json_encode(['error' => 'Query failed: ' . mysqli_error($conn)]);
    mysqli_close($conn);
    exit;
}
$members = [];
while ($row = mysqli_fetch_assoc($result)) {
    foreach ($row as $key => $value) {
        $row[$key] = $value ?? '';
    }
    $members[] = $row;
}
mysqli_free_result($result);
mysqli_close($conn);
echo json_encode($members, JSON_UNESCAPED_UNICODE);
exit;
?>
