<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>BNI Members Directory</title>
  <link href="images/logo.jpeg" rel="icon">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      background-color: #f8f9fa;
    }

    .card {
      transition: 0.3s ease;
      cursor: pointer;
      border: none;
      border-radius: 12px;
      overflow: hidden;
    }

    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 6px 16px rgba(0, 0, 0, 0.15);
    }

    .card img {
      height: 230px;
      object-fit: cover;
    }

    .card-body {
      background: #fff;
    }

    .social-icons a {
      color: #0d6efd;
      font-size: 1.2rem;
      margin-right: 10px;
      transition: 0.3s;
    }

    .social-icons a:hover {
      color: #0056b3;
    }

    a.card-link {
      text-decoration: none;
      color: inherit;
    }
  </style>
</head>

<body>
  <!-- Header -->
  <header class="bg-dark text-white text-center py-3 mb-4">
    <div class="container">
      <h2 class="fw-bold mb-0"><i class="bi bi-people-fill me-2"></i>BNI Members Directory</h2>
    </div>
  </header>

  <!-- Members Container -->
  <div class="container py-4">
    <div id="loadingSpinner" class="text-center my-5">
      <div class="spinner-border text-primary mb-2" role="status"></div>
      <p class="text-muted">Loading members...</p>
    </div>

    <div class="row g-4" id="memberCards"></div>
  </div>

  <!-- Footer -->
  <footer class="bg-dark text-center text-white py-3 mt-5">
    <p class="mb-0">&copy; <?php echo date("Y"); ?> BNI Members Portal | All Rights Reserved</p>
  </footer>

  <!-- JS -->
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    $(document).ready(function () {
      function escapeHtml(str) {
        if (!str) return '';
        return $('<div/>').text(str).html();
      }

      function loadMembers() {
        $('#loadingSpinner').show();
        $('#memberCards').empty();

        $.ajax({
          url: 'fetch_members.php',
          type: 'GET',
          dataType: 'json',
          success: function (members) {
            $('#loadingSpinner').hide();
            const container = $('#memberCards');

            if (members.error) {
              container.append(`<p class="text-danger text-center">${escapeHtml(members.error)}</p>`);
              return;
            }

            if (members.length === 0) {
              container.append('<p class="text-center text-muted">No members found.</p>');
              return;
            }

            $.each(members, function (_, m) {
              const facebook = m.facebook_link
                ? `<a href="${escapeHtml(m.facebook_link)}" target="_blank"><i class="bi bi-facebook"></i></a>` : '';
              const youtube = m.youtube_link
                ? `<a href="${escapeHtml(m.youtube_link)}" target="_blank"><i class="bi bi-youtube"></i></a>` : '';

              const imgSrc = m.photo ? escapeHtml(m.photo) : 'images/default-profile.png';

              const card = `
                <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                  <div class="card shadow-sm h-100" data-id="${m.ask_id}">
                    <img src="${imgSrc}" class="card-img-top" alt="${escapeHtml(m.full_name)}">
                    <div class="card-body text-center">
                      <h5 class="card-title fw-bold text-primary mb-1">${escapeHtml(m.full_name)}</h5>
                      <p class="text-secondary mb-1"><i class="bi bi-briefcase me-1"></i>${escapeHtml(m.category)}</p>
                      <p class="small text-muted mb-2">${escapeHtml(m.brief_business_desc)}</p>
                      <div class="social-icons">${facebook} ${youtube}</div>
                    </div>
                  </div>
                </div>`;
              container.append(card);
            });

            // Click event to open member details
            $('.card').on('click', function() {
              const id = $(this).data('id');
              if (id) {
                window.location.href = 'member-details.php?id=' + id;
              }
            });
          },
          error: function () {
            $('#loadingSpinner').hide();
            $('#memberCards').append('<p class="text-danger text-center">Error loading members.</p>');
          }
        });
      }

      loadMembers();
    });
  </script>
</body>
</html>
