
<?php 
include_once 'session/session.php'; 
include_once 'classes/settings.php'; 
include_once 'classes/class_db.php'; 
$ObjDB = new class_settings(); 
$conn = $ObjDB->MyConnectDB(); 
$contact_number = $_SESSION['contact_number']; 
$result = mysqli_query($conn, "SELECT * FROM bni_members_tbl WHERE contact_number='$contact_number'");
$row = mysqli_fetch_assoc($result);
if (!$row) die("No member found.");
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $photo_path = $row['photo']; // keep existing photo by default

    // Handle photo upload
    if (isset($_FILES['photo_file']) && $_FILES['photo_file']['error'] === UPLOAD_ERR_OK) {
        $file_tmp = $_FILES['photo_file']['tmp_name'];
        $file_name = basename($_FILES['photo_file']['name']);
        $ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','gif'];
        if (in_array($ext, $allowed)) {
            $upload_dir = 'images';
            if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
            $new_name = $upload_dir . '/' . time() . '_' . $file_name;
            if (move_uploaded_file($file_tmp, $new_name)) {
                $photo_path = $new_name;
            }
        }
    }
    $full_name = mysqli_real_escape_string($conn, $_POST['full_name']);
    $category = mysqli_real_escape_string($conn, $_POST['category']);
    $brief_personal_desc = mysqli_real_escape_string($conn, $_POST['brief_personal_desc']);
    $brief_business_desc = mysqli_real_escape_string($conn, $_POST['brief_business_desc']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);
    $facebook_link = mysqli_real_escape_string($conn, $_POST['facebook_link']);
    $youtube_link = mysqli_real_escape_string($conn, $_POST['youtube_link']);
    $their_give = mysqli_real_escape_string($conn, $_POST['their_give']);
    $their_ask = mysqli_real_escape_string($conn, $_POST['their_ask']);

    // Update database
    $update_query = "UPDATE bni_members_tbl SET photo='$photo_path', full_name='$full_name', category='$category', brief_personal_desc='$brief_personal_desc', brief_business_desc='$brief_business_desc', address='$address', facebook_link='$facebook_link', youtube_link='$youtube_link', their_give='$their_give', their_ask='$their_ask', timestamp=NOW() WHERE contact_number='$contact_number'";
    if (mysqli_query($conn, $update_query)) {
        $success = "Data updated successfully!";
        $row = mysqli_query($conn, "SELECT * FROM bni_members_tbl WHERE contact_number='$contact_number'");
        $row = mysqli_fetch_assoc($row);
    } else {
        $error = "Failed to update data: " . mysqli_error($conn);
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>BNI Member Profile</title>
    <link href="images/logo.jpeg" rel="icon">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <!-- Header -->
    <header class="bg-dark text-white p-3">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center">
                <h2>BNI Member Profile</h2>
                <a href="logout.php" class="btn btn-danger">Logout</a>
            </div>
        </div>
    </header>

    <div class="container mt-4">
        <?php if(isset($success)): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php elseif(isset($error)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <form method="post" enctype="multipart/form-data">
            <div class="mb-3">
                <label class="form-label">Photo</label>
                <input type="file" class="form-control" name="photo_file" accept="image/*">
                <?php if(!empty($row['photo'])): ?>
                    <img src="<?php echo htmlspecialchars($row['photo']); ?>" alt="Photo" class="img-thumbnail mt-2" width="150">
                <?php endif; ?>
            </div>
            <div class="mb-3">
                <label class="form-label">Full Name</label>
                <input type="text" class="form-control" name="full_name" value="<?php echo htmlspecialchars($row['full_name']); ?>" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Category</label>
                <input type="text" class="form-control" name="category" value="<?php echo htmlspecialchars($row['category']); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">Brief Personal Description</label>
                <textarea class="form-control" name="brief_personal_desc"><?php echo htmlspecialchars($row['brief_personal_desc']); ?></textarea>
            </div>
            <div class="mb-3">
                <label class="form-label">Brief Business Description</label>
                <textarea class="form-control" name="brief_business_desc"><?php echo htmlspecialchars($row['brief_business_desc']); ?></textarea>
            </div>
            <div class="mb-3">
                <label class="form-label">Address</label>
                <input type="text" class="form-control" name="address" value="<?php echo htmlspecialchars($row['address']); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">Contact Number</label>
                <input type="text" class="form-control" value="<?php echo htmlspecialchars($row['contact_number']); ?>" readonly>
            </div>
            <div class="mb-3">
                <label class="form-label">Facebook Link</label>
                <input type="url" class="form-control" name="facebook_link" value="<?php echo htmlspecialchars($row['facebook_link']); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">YouTube Link</label>
                <input type="url" class="form-control" name="youtube_link" value="<?php echo htmlspecialchars($row['youtube_link']); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">Their Give</label>
                <input type="text" class="form-control" name="their_give" value="<?php echo htmlspecialchars($row['their_give']); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">Their Ask</label>
                <input type="text" class="form-control" name="their_ask" value="<?php echo htmlspecialchars($row['their_ask']); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">OTP</label>
                <input type="text" class="form-control" value="<?php echo htmlspecialchars($row['otp']); ?>" readonly>
            </div>
            <div class="mb-3">
                <label class="form-label">Status</label>
                <input type="text" class="form-control" value="<?php echo $row['status'] ? 'Active' : 'Inactive'; ?>" readonly>
            </div>
            <div class="mb-3">
                <label class="form-label">Added On</label>
                <input type="text" class="form-control" value="<?php echo $row['add_datetime']; ?>" readonly>
            </div>
            <!-- <div class="mb-3">
                <label class="form-label">Last Updated</label>
                <input type="text" class="form-control" value="<?php echo $row['timestamp']; ?>" readonly>
            </div> -->
            <button type="submit" class="btn btn-primary">Save</button>
        </form>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white p-3 mt-4">
        <div class="container">
            <p class="text-center mb-0">&copy; 2025 BNI. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
