<?php

error_reporting(E_ERROR | E_PARSE);
include_once './preview.inc.php';
require_once('../tcpdf/tcpdf.php');

class MYPDF extends TCPDF {

    public function Header() {
        $objectnew = new class_student();
        $student_id = $objectnew->student_id = $_SESSION['student_sessionid'];
        $result_studentdetails = $objectnew->GetStudentDetails();
        if (mysqli_num_rows($result_studentdetails) > 0) {
            $row_studentdetails = mysqli_fetch_assoc($result_studentdetails);
        }
        $this->SetFont('helvetica', 'B', 8);
        $view_tbl .= '<br/><br/>
<table width="100%" cellpadding="0" cellspacing="0" style="font-size: 18px;">
<tr>
<td width="10%" style="line-height: 24px;"><img src="../images/slogo.png" alt="" style="width:60px;"></td>
<td width="60%" style="line-height: 20px;">
<br/><b style="font-size: 16px;">Deen Dayal Upadhyaya Gorakhpur University</b>
<br/><b style="font-size: 12px;">Provisional Admit Card  (Student Copy)</b>
<br/><b style="font-size: 12px;">SESSION : 2024-2025</b>
</td>
<td width="30%" style="line-height: 24px;text-align:right;">
<br/><b style="font-size: 14px;">Roll No. : ' . common::StrFromDb($row_studentdetails[test_roll_number]) . '</b>
</td>
</tr>
</table>';
        $this->writeHTML($view_tbl, true, false, true, false, '');
        $this->Cell(0, 0, ' ', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    public function Footer() {
        $this->SetY(-25);

        $this->SetFont('helvetica', 'I', 8);
        $view_tbl .= '';

//        $view_tbl .= '';
        $this->writeHTML($view_tbl, true, false, true, false, '');
        $this->Cell(0, 0, ' ', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }

}

$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Deen Dayal Upadhyaya Gorakhpur University');
$pdf->SetTitle('Deen Dayal Upadhyaya Gorakhpur University');
$pdf->SetSubject('Deen Dayal Upadhyaya Gorakhpur University');
$pdf->SetKeywords('Deen Dayal Upadhyaya Gorakhpur University');
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(1);
$pdf->SetAutoPageBreak(TRUE, 1);
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
$pdf->AddPage('A4');
$today_date = date("Y-m-d");
$display_date = date("d-m-Y");
$today_date = date("d-M, Y", strtotime($today_date));

$file_name = "Student-" . $row_studentdetails['test_roll_number'] . ".pdf";

if ($row_studentdetails['course'] == "BA") {
    $entrance_time = "14 March 2024 (1:30 p.m. to 4:30 p.m.)";
} elseif ($row_studentdetails['course'] == "BSC-PCM") {
    $entrance_time = "14 March 2024 (9:00 a.m. to 12:00 noon)";
} elseif ($row_studentdetails['course'] == "BSC-ZBC") {
    $entrance_time = "07 March 2024 (1:30 p.m. to 4:30 p.m.)";
} elseif ($row_studentdetails['course'] == "BHSC") {
    $entrance_time = "07 March 2024 (1:30 p.m. to 4:30 p.m.)";
} elseif ($row_studentdetails['course'] == "BCOM") {
    $entrance_time = "07 March 2024 (9:00 a.m. to 12:00 noon)";
}

$view_tbl .= '<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8"/>
        <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
        <meta name="description" content=""/>
        <meta name="author" content=""/>
        <title>Deen Dayal Upadhyaya Gorakhpur University</title>
        <style type="text/css">
            body, html{
                font-family: arial;
                font-size: 12px;
            }
            td{
                padding: 5px;
            }
        </style>
    </head>
    <body><br/>
<table border="0" cellspacing="0" width="100%">
<tr>
            <td valign="top" width="75%">
                <table cellspacing="0" cellpadding="4" border="0" width="100%">
                    <tr>
                        <td><b>Name</b></td>
                        <td><b>:</b></td>
                        <td>' . common::StrFromDb($row_studentdetails['student_name']) . '</td>
                    </tr>
                    <tr>
                        <td><b>Reg. No.</b></td>
                        <td><b>:</b></td>
                        <td>' . common::StrFromDb($row_studentdetails['registration_number']) . '</td>
                    </tr>
                    <tr>
                        <td><b>Address</b></td>
                        <td><b>:</b></td>
                        <td>' . common::StrFromDb($row_studentdetails['present_address']) . '</td>
                    </tr>
                    <tr>
        <td colspan="3" style="font-size:13px;"><br/>&nbsp;<br/><strong>Entrance Test Schedule:</strong></td>    
    </tr>';
$view_tbl .= '</table>
</td>
<td valign="top" width="25%" style="text-align:right;">';
if ($passport_photograph != "") {
    $view_tbl .= '<img src="upload_docs/' . $passport_photograph . '" style="width: 90px;height: 100px;"/>';
}
$view_tbl .= '</td></tr></table>';
$view_tbl .= '<table border="0" cellspacing="0" width="100%">
<tr>
            <td valign="top" width="100%">.
        <table cellspacing="0" cellpadding="5" border="0" width="100%" style="font-size:12px;">
        
        <tr>
        <td width="10%"><b><u>Program:</u></b></td>
        <td width="20%"><b>' . common::StrFromDb($row_studentdetails['course']) . '</b></td>
        <td width="13%"><b><u>Date & Time:</u></b></td>
        <td width="57%"><b>' . $entrance_time . '</b></td>
    </tr>
    <tr>
        <td colspan="4" style="text-align:center;"><b>Examination Centre :  Deen Dayal Upadhyaya Gorakhpur University</b></td>
    </tr>
</table></td></tr></table>';

$view_tbl .= '<table border="0" cellspacing="0" width="100%">
<tr>
            <td valign="top" width="100%">
    <table cellspacing="0" cellpadding="3" border="0" width="100%" style="font-size:10px;">
    <tr>
        <td style="font-size:13px;"><br/>&nbsp;<br/><strong>Note:</strong></td>    
    </tr>
        <tr>
            <td>1. Candidate must bring this Admit card, Black/Blue Ball Pen at the time of Entrance Examination.</td>
        </tr>
        <tr>
            <td>2. Please take printout of Admit Card from University Website and report at the Entrance Examination Centre before 30 minutes of the commencement of examination.</td>
        </tr>
        <tr>
            <td>3. Keep visiting university website: <a href="http://localhost/ddugu-admission/">http://localhost/ddugu-admission/</a> for further information.</td>
        </tr>';

$view_tbl .= '</table></td></tr></table>';


$view_tbl .= '<table border="0" cellspacing="0" width="100%">
<tr>
            <td valign="top" width="100%"><table cellspacing="0" cellpadding="2" border="0" width="100%">
        <tr>
            <td width="70%"><br/>&nbsp;<br/>&nbsp;<br/>&nbsp;<br/>&nbsp;<br/>
            
             <br/><strong> </strong>
             </td>
             <td width="30%" align="center"><br/>&nbsp;<br/>&nbsp;<br/>&nbsp;<br/>&nbsp;<br/>';
$view_tbl .= '-------------------------------------------
    <br/><strong>Candidate Signature<div style="font-size:10px;">(In Examination Hall)</div>
 </strong>';
$view_tbl .= '</td>
    </tr>';

$view_tbl .= '</table></td></tr></table>';

$view_tbl .= '</body></html>';
$html = <<<EOF
<!-- EXAMPLE OF CSS STYLE -->
<style>
body {font-family:arial; font-size:10px;}
td {font-family:arial; font-size:10px;}
td.this {border-left:1px solid steelblue; border-top:1px solid steelblue;}
td.this2 {border:1px solid steelblue; border-top:1px solid steelblue;}

th.this {border-left:1px solid steelblue; border-top:1px solid steelblue;}
table.this {border-right:1px solid steelblue; border-bottom:1px solid steelblue;}

</style>

 $view_tbl
EOF;
//echo $html;
$pdf->writeHTML($html, true, false, true, false, '');
$pdf->Output($file_name, 'D');
//$pdf->Output($file_name);
?>
