<?php

class common {

    public static function StrToDB($str) {
        $str = str_replace("'", "&#39;", $str);
        $str = str_replace('"', "&#34;", $str);
        $str = str_replace("\n", "&#nl;", $str);
        $str = str_replace("\r", "&#rl;", $str);

        return $str;
    }

    public static function StrFromDb($str) {
        $str = str_replace("&#39;", "'", $str);
        $str = str_replace("&#34;", '"', $str);
        $str = str_replace("&#nl;", "\n", $str);
        $str = str_replace("&#rl;", "\r", $str);

        return $str;
    }

    public function uniqueotpcode($ct) {
        $code = '';
        $data = '';
        srand((double) microtime() * 1000000);
        $data = "1592634879";
        for ($i = 0; $i < $ct; $i++) {
            $code .= substr($data, (rand() % (strlen($data))), 1);
        }
        return $code;
    }

    public function uniqueid($ct) {
        $code = '';
        $data = '';
        srand((double) microtime() * 1000000);
        $data = "AbcDE123IJKLMN67QRSTUVWXYZ";
        $data .= "aBCdefghijklmn123opq45rs67tuv89wxyz";
        $data .= "0FGH45OP89";
        for ($i = 0; $i < $ct; $i++) {
            $code .= substr($data, (rand() % (strlen($data))), 1);
        }
        return $code;
    }

    public function GetID($type) {
        $ID = "";
        switch ($type) {
            case "STU":
                $ID = 'STU' . date('Ymdhis') . $this->uniqueid(5);
                break;
        }
        switch ($type) {
            case "MTR":
                $ID = 'MTR' . date('Ymdhis') . $this->uniqueid(5);
                break;
        }
        switch ($type) {
            case "JSR":
                $ID = 'JSR' . date('Ymdhis') . $this->uniqueid(5);
                break;
        }
        switch ($type) {
            case "EMP":
                $ID = 'EMP' . date('Ymdhis') . $this->uniqueid(5);
                break;
        }
        switch ($type) {
            case "EDU":
                $ID = 'EDU' . date('Ymdhis') . $this->uniqueid(5);
                break;
        }
        switch ($type) {
            case "SADM":
                $ID = 'SADM' . date('Ymdhis') . $this->uniqueid(4);
                break;
        }
        switch ($type) {
            case "TRANS":
                $ID = 'TRANS_' . date('Ymdhis') . $this->uniqueid(10);
                break;
        }
        return $ID;
    }

    public function DeleteImage($type, $file_name) {
        switch ($type) {
            case "pro":
                $img_dirlarge = "prodimg/";
                break;
            case "bra":
                $img_dirlarge = "brandimg/";
                break;
            case "prf":
                $img_dirlarge = "profimgimg/";
                break;
        }
        unlink($img_dirlarge . $file_name);
        unlink($img_dirlarge . "s_" . $file_name);
        return "ok";
    }

    public function CreateThumb($type, $file_name) {
        //PRF - profile, PRO-product,BRA-brand
        switch ($type) {
            case "pro":
                $img_dirlarge = "prodimg/";
                break;
            case "bra":
                $img_dirlarge = "brandimg/";
                break;
            case "prf":
                $img_dirlarge = "profimgimg/";
                break;
        }
//Clean the Filename
        $img = explode('.', $file_name);
//Thumbnail file
        $image_filePath = $img_dirlarge . $file_name; //$_FILES['imageSource']['tmp_name'];
//Rename the thumbnail Image
        $krowAvatar = "s_" . $img[0] . "." . $img[1];
        $img_thumbLarge = $img_dirlarge . $krowAvatar;
//String lower case
        $extension = strtolower($img[1]);
//Check the file format before upload
        if (in_array($extension, array('jpg', 'jpeg', 'gif', 'png', 'bmp'))) {
            //Find the height and width of the image
            list($gotwidth, $gotheight, $gottype, $gotattr) = getimagesize($image_filePath);
            //Find the image type
            //---------- To create thumbnail of image---------------
            if ($extension == "jpg" || $extension == "jpeg") {
                $src = imagecreatefromjpeg($image_filePath);
            } else if ($extension == "png") {
                $src = imagecreatefrompng($image_filePath);
            } else {
                $src = imagecreatefromgif($image_filePath);
            }
            //Get the height and width of uploaded image
            list($width, $height) = getimagesize($image_filePath);

// ----------------------------------------------------
            //Set new width for image
            $newwidthLarge = 50;

            //Set new height for image
            // $newheightLarge=160;
            // or Calculate and scale it proportanly
            $newheightLarge = round(($height * $newwidthLarge) / $height);

// ----------------------------------------------------
            //Creating the thumbnail from true color
            $tmp = imagecreatetruecolor($newwidthLarge, $newheightLarge);
            //Enable image interlace property
            imageinterlace($tmp, 1);
            //Create a image with given dimension
            imagecopyresampled($tmp, $src, 0, 0, 0, 0, $newwidthLarge, $newheightLarge, $width, $height);
            //Put the image data to newly created Image
            $createImageSave = imagejpeg($tmp, $img_thumbLarge, 100);
        }
        return $file_name;
    }

    public function humanTiming($time) {
        $time = time() - $time; // to get the time since that moment
        $tokens = array(
            31536000 => 'year',
            2592000 => 'month',
            604800 => 'week',
            86400 => 'day',
            3600 => 'hour',
            60 => 'minute',
            1 => 'second'
        );
        foreach ($tokens as $unit => $text) {
            if ($time < $unit)
                continue;
            $numberOfUnits = floor($time / $unit);
            return $numberOfUnits . ' ' . $text . (($numberOfUnits > 1) ? 's' : '');
        }
    }

    function IND_money_format($money) {
        $len = strlen($money);
        $m = '';
        $money = strrev($money);
        for ($i = 0; $i < $len; $i++) {
            if (( $i == 3 || ($i > 3 && ($i - 1) % 2 == 0) ) && $i != $len) {
                $m .= ',';
            }
            $m .= $money[$i];
        }
        return strrev($m);
    }

    public static function urlformation($textforurl) {

        $filtered_words = array(
            'a', 'an', 'as', 'at', 'before', 'but', 'by', 'for', 'from', 'is', 'in', 'into',
            'like', 'of', 'off', 'on', 'onto', 'per', 'since', 'than', 'the', 'this', 'that', 'to', 'up',
            'via', 'with'
        );

        $textforurl_array = explode(' ', $textforurl);
        $textforurl_array_final = array_diff($textforurl_array, $filtered_words);
        $textforurl_new = implode(' ', $textforurl_array_final);

        $textforurl_new = strtolower($textforurl_new);

        $textforurl_new = str_replace("-", " ", $textforurl_new);
        $textforurl_new = preg_replace('/[^A-Za-z0-9 -]/', '', $textforurl_new);
        $textforurl_new = trim(preg_replace('/\s+/', ' ', $textforurl_new));
        $textforurl_new = str_replace(" ", "-", $textforurl_new);
        $textforurl_new = str_replace(".", "", $textforurl_new);
        $textforurl_new = str_replace("&", "", $textforurl_new);

        return $textforurl_new;
    }

    public static function SearchKeyword($textforurl) {

        $filtered_words = array(
            'a', 'an', 'as', 'at', 'before', 'but', 'by', 'for', 'from', 'is', 'in', 'into',
            'like', 'of', 'off', 'on', 'onto', 'per', 'since', 'than', 'the', 'this', 'that', 'to', 'up',
            'via', 'with'
        );

        $textforurl_array = explode(' ', $textforurl);
        $textforurl_array_final = array_diff($textforurl_array, $filtered_words);
        $textforurl_new = implode(',', $textforurl_array_final);

        $textforurl_new = strtolower($textforurl_new);

        $textforurl_new = str_replace("-", " ", $textforurl_new);
        $textforurl_new = preg_replace('/[^A-Za-z0-9 -,]/', '', $textforurl_new);
        $textforurl_new = trim(preg_replace('/\s+/', ' ', $textforurl_new));
        $textforurl_new = str_replace(" ", "-", $textforurl_new);
        $textforurl_new = str_replace(".", "", $textforurl_new);
        $textforurl_new = str_replace("&", "", $textforurl_new);
        return $textforurl_new;
    }

    function recalluniqueregistrationidfunc($usertype) {
        $this->uniqueregistrationid($usertype);
    }

    function uniqueregistrationid($usertype) {
        $usertype = str_replace("-", "", $usertype);
        $Objdb = new class_db();
        $current_year = date("y");
        $querycount = "SELECT COUNT(unique_id) as count_login FROM itdc_selected_program_tbl WHERE program_id='$usertype'";
        $Objdb->sproc_name = $querycount;
        $resultcount = $Objdb->SelectQuery();
        list($count_login) = mysqli_fetch_row($resultcount);
        $count_number = $count_login + 1;
        $last_increment_number = str_pad($count_number, 3, "0", STR_PAD_LEFT);
        $registration_number = $usertype . $current_year . $last_increment_number;
        $querycountfinal = "SELECT unique_id FROM itdc_selected_program_tbl WHERE unique_id='$registration_number'";
        $Objdb->sproc_name = $querycountfinal;
        $resultcountfinal = $Objdb->SelectQuery();
        $count_unique = mysqli_num_rows($resultcountfinal);
        if ($count_unique == 0) {
            return $registration_number;
        } else {
            $this->recalluniqueregistrationidfunc($usertype);
        }
    }

    public static function str_decrypt($decodeMe) {

        $decode = base64_decode($decodeMe); //Decoding the string from base64.
        $decode = strrev($decode);
        return $decode; //Returns the decoded string.
    }

    public static function str_encrypt($encodeMe) {

        $encode = strrev($encodeMe);
        $encode = base64_encode($encode); //Encoding the string to base64.
        return $encode; //Returns the encoded string.
    }

    public static function GetAmountInWord($number) {
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(0 => '', 1 => 'one', 2 => 'two',
            3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
            7 => 'seven', 8 => 'eight', 9 => 'nine',
            10 => 'ten', 11 => 'eleven', 12 => 'twelve',
            13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
            16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
            19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
            40 => 'forty', 50 => 'fifty', 60 => 'sixty',
            70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
        $digits = array('', 'hundred', 'thousand', 'lakh', 'crore');
        while ($i < $digits_length) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else
                $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal) ? " " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return $Rupees . " " . $paise . " Only";
    }

}

?>
