<?php
ob_start();
include_once './couns-upload.inc.php';
?>
<div class="boxed-area-white">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <fieldset>
                    <legend class="text-uppercase text-warning">Upload Files</legend>
                    <form method="post" enctype="multipart/form-data" class="form-horizontal">
                        <div class="col-md-9">
                            <div id="form_successmsgid">
                                <?php if ($error_msg['res_status'] == "10") { ?>
                                    <div class="text-center alert alert-success">
                                        File successfully Uploaded
                                    </div>
                                <?php } elseif ($error_msg['res_status'] == "20") { ?>
                                    <div class="text-center alert alert-danger">
                                        Something Wrong. Please try again
                                    </div>
                                <?php } ?>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-4 control-label">Select File Type <span class="text-danger">*</span></label>
                                <div class="col-sm-7">                                
                                    <select name="document_type" id="document_type" class="form-control">
                                        <option value="">Select File</option>  
                                        <?php
                                        if (mysqli_num_rows($result_masterdocument) > 0) {
                                            while ($row_masterdocument = mysqli_fetch_array($result_masterdocument)) {
                                                ?>
                                                <option value="<?php echo $row_masterdocument['did']; ?>" <?php if ($row_masterdocument['did'] == $document_type) { ?> selected="" <?php } ?>><?php echo $row_masterdocument['document_name']; ?></option>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </select>
                                    <font color="red"><?php echo $error_msg['document_type']; ?></font>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="col-sm-4 control-label">Select File to Upload <span class="text-danger">*</span></label>
                                <div class="col-sm-7">                                
                                    <input type="file" class="form-control input-sm" name="doc_file" id="doc_file"/>
                                    <font color="red"><?php echo $error_msg['select_docfile']; ?></font>
                                    <div class="clearfix"></div>
                                    <small>
                                        <font color=red><b>IMPORTANT</b></font><br>All documents for upload must be in pdf format except the passport size photograph and signature. <br>
                                        The passport size photograph and signature must be jpg or png type.<br>
                                        Maximum file size: 100KB.<br/>
                                        Upload affidavit if you are uploading internet marksheet of class 12th. <a href="../ug-affidavit-performa.pdf" target="_blank">(Click to download proforma)</a>
                                    </small>
                                </div>
                            </div>
                            <div class="clearfix"></div><br/>
                            <div class="form-group">
                                <div class="col-sm-4"></div>                                
                                <div class="col-sm-4">                                
                                    <input type="submit" name="upload_doc" id="upload_doc" value="Submit" class="btn btn-primary btn-sm"/>
                                    <a id="processing_divid" class="btn btn-primary btn-sm" style="display: none;">Processing...</a>
                                </div>
                                <div class="col-sm-3 pull-right">
                                    <a href="couns-preview.php" class="btn btn-primary btn-sm">Click to Next Step</a>
                                </div>
                            </div> 
                        </div> 
                    </form>
                </fieldset> 
            </div>
        </div>
    </div>
</div>
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <fieldset>
                <legend class="text-uppercase text-warning">Preview</legend>
                <div class="table-responsive">
                    <table class="table table-responsive">
                        <tr>
                            <th style="border: 0px;"></th>
                            <th style="border: 0px;">Document Type</th>
                            <th style="border: 0px;">View</th>
                            <th style="border: 0px;">Action</th>
                        </tr>
                        <?php
                        $i = 1;
                        if (mysqli_num_rows($result_uploadeddocument) > 0) {
                            while ($row_uploadeddocument = mysqli_fetch_array($result_uploadeddocument)) {
                                ?>
                                <tr>
                                    <td><?php echo $i; ?></td>
                                    <td><?php echo $row_uploadeddocument['document_name']; ?></td>
                                    <td><a href="./upload_docs/<?php echo $row_uploadeddocument['upload_document']; ?>" download="">Download</a></td>
                                    <td><a style="cursor: pointer;" onclick="DeleteUploadedDocument('<?php echo $row_uploadeddocument['uid']; ?>');">Delete</a></td>
                                </tr>
                                <?php
                                $i++;
                            }
                        }
                        ?>
                    </table>
                </div>
            </fieldset>
        </div>
    </div>
</div>
<div class="clearfix"></div><br/><br/>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'upload_documents';
$HTMLTITLE = '';
$HTMLDESCRIPTION = '';
$HTMLKEYWORDS = '';
include("./masters/user-master.php");
?>
<script type="text/javascript">
    function DeleteUploadedDocument(document_id) {
        if (confirm("Are you sure you want to delete this document?")) {
            $.ajax({
                type: "POST",
                url: "couns-upload.inc.php",
                data: "document_id=" + document_id + "&action=delete_document",
                success: function (data) {
                    alert('Document successfully deleted');
                    window.location = 'couns-upload.php';
                }
            });
        }
    }
</script>