<?php

include_once './classes/DB.class.pg.php';

$db = new DB();

/* Program Id is placed at college list table result table and choice table */

//$ProgramId = $_REQUEST['ProgramId'];

$TestCode = "321";


$CollegeListArr = $db->selectWithCols("itdc_college_list_tbl", "cid, college_name, program_type, male_female", "program_id='55'");
$ProgramTypeArr = array();
$College_Name_Arr = array();
$Gender_Arr = array();

foreach ($CollegeListArr as $CLA) {
    $ProgramTypeArr[$CLA['cid']] = $CLA['program_type'];
    $College_Name_Arr[$CLA['cid']] = $CLA['college_name'];
    if ($CLA['male_female'] == "20") {
        $male_female = "Female";
    } else {
        $male_female = "Both";
    }

    $Gender_Arr[$CLA['cid']] = $male_female;
}

/* EWS category students are not coming here */
$Student_Arr = $db->selectWithCols("itdc_result_tbl", "result_id,registration_number, login_id, category, subcategory,category_verify, marks_with_weightage, program_id, "
        . "general_rank, category_rank, gender", "subcategory !='' AND present_status='P' AND test_code='$TestCode' AND category!='General (EWS)' AND seat_allotment_status='20' AND employee_ward_quota='20' AND choice_lock_status='10' ORDER BY marks_with_weightage DESC, inter_percentage DESC, student_age DESC");

foreach ($Student_Arr as $SA) {
    $seat_alloted_flag = "2";
    
    $LoginId = $SA['login_id'];
    $category = $SA['category'];
    $subcategory = $SA['subcategory'];
    $gender = $SA['gender'];
    $ProgramId = $SA['program_id'];
    
    
    
    
    /*
      Specially Abled (Divyang),
      Ex-Servicemen and martyrs of war, security personnel handicapped in war or their dependents
      Dependants of freedom fighters (Son/daughter/grandson/granddaughter/great-granddaughter/great-grandson)
      Armed Forces Personnel and their dependents (Husband/wife/son/daughter)
      Dependents of kargil martyrs
     */

    $cat_col = "";
    $sub_cat_col = "";
    if ($category == "General") {
        $cat_col = "GC";
        if ($subcategory == "Specially Abled (Divyang)") {
            $sub_cat_col = "GP";
        } else if ($subcategory == "Ex-Servicemen and martyrs of war, security personnel handicapped in war or their dependents") {
            $sub_cat_col = "GEX";
        } else if ($subcategory == "Dependants of freedom fighters (Son/daughter/grandson/granddaughter/great-granddaughter/great-grandson)") {
            $sub_cat_col = "GF";
        } else if ($subcategory == "Armed Forces Personnel and their dependents (Husband/wife/son/daughter)") {
            $sub_cat_col = "GS";
        } else if ($subcategory == "Displaced Kashmiri Pandits/Kashmiri Pandits residing in the Kashmir Valley/dependents of Kashmiri hindu families") {
            $sub_cat_col = "GKM";
        } else if ($subcategory == "Dependents of kargil martyrs") {
            $sub_cat_col = "GKG";
        }
    } else if ($category == "OBC") {
        $cat_col = "BC";
        if ($subcategory == "Specially Abled (Divyang)") {
            $sub_cat_col = "BP";
        } else if ($subcategory == "Ex-Servicemen and martyrs of war, security personnel handicapped in war or their dependents") {
            $sub_cat_col = "BEX";
        } else if ($subcategory == "Dependants of freedom fighters (Son/daughter/grandson/granddaughter/great-granddaughter/great-grandson)") {
            $sub_cat_col = "BF";
        } else if ($subcategory == "Armed Forces Personnel and their dependents (Husband/wife/son/daughter)") {
            $sub_cat_col = "BS";
        } else if ($subcategory == "Displaced Kashmiri Pandits/Kashmiri Pandits residing in the Kashmir Valley/dependents of Kashmiri hindu families") {
            $sub_cat_col = "BKM";
        } else if ($subcategory == "Dependents of kargil martyrs") {
            $sub_cat_col = "BKG";
        }
    } else if ($category == "SC") {
        $cat_col = "SC";
        if ($subcategory == "Specially Abled (Divyang)") {
            $sub_cat_col = "SP";
        } else if ($subcategory == "Ex-Servicemen and martyrs of war, security personnel handicapped in war or their dependents") {
            $sub_cat_col = "SEX";
        } else if ($subcategory == "Dependants of freedom fighters (Son/daughter/grandson/granddaughter/great-granddaughter/great-grandson)") {
            $sub_cat_col = "SF";
        } else if ($subcategory == "Armed Forces Personnel and their dependents (Husband/wife/son/daughter)") {
            $sub_cat_col = "SS";
        } else if ($subcategory == "Displaced Kashmiri Pandits/Kashmiri Pandits residing in the Kashmir Valley/dependents of Kashmiri hindu families") {
            $sub_cat_col = "SKM";
        } else if ($subcategory == "Dependents of kargil martyrs") {
            $sub_cat_col = "SKG";
        }
    } else if ($category == "ST") {
        $cat_col = "ST";
        if ($subcategory == "Specially Abled (Divyang)") {
            $sub_cat_col = "STP";
        } else if ($subcategory == "Ex-Servicemen and martyrs of war, security personnel handicapped in war or their dependents") {
            $sub_cat_col = "STEX";
        } else if ($subcategory == "Dependants of freedom fighters (Son/daughter/grandson/granddaughter/great-granddaughter/great-grandson)") {
            $sub_cat_col = "STF";
        } else if ($subcategory == "Armed Forces Personnel and their dependents (Husband/wife/son/daughter)") {
            $sub_cat_col = "STS";
        } else if ($subcategory == "Displaced Kashmiri Pandits/Kashmiri Pandits residing in the Kashmir Valley/dependents of Kashmiri hindu families") {
            $sub_cat_col = "STKM";
        } else if ($subcategory == "Dependents of kargil martyrs") {
            $sub_cat_col = "STKG";
        }
    }

    /* Getting the choices of 3 subjects */
    $Choice_List_Arr = $db->selectWithCols("itdc_student_choice_tbl", "cid, college_id, subject_one, subject_two, subject_three, choice_series", "status='10' AND student_id='$LoginId' AND program_id='$ProgramId' ORDER BY choice_series ASC");
    foreach ($Choice_List_Arr as $CLA) {

        $under_category_allotment = "";
        $choice_alloted_series = "";

        

        $subject_one = $CLA['subject_one'];
        $subject_two = $CLA['subject_two'];
        $subject_three = $CLA['subject_three'];
        $choice_series = $CLA['choice_series'];

        $choice_pk_id = $CLA['cid'];
        $college_id = $CLA['college_id'];
        
        
     
        if($college_id == "15" || $college_id == "25"){
            $college_id = "25";
        }
        
        $program_type = $ProgramTypeArr[$college_id];

        $college_gender = $Gender_Arr[$college_id];

        $allow_gender_flag = "1";
        $seat_alloted_flag = "2";

        if ($college_gender == "Female" && $gender == "Male") {
            /* Here , Gender male is not alloed in female college */
            $allow_gender_flag = "2";
        }

        if ($allow_gender_flag == "1") {
            $SeatAllotmentRes = FunSubjectChoiceProcess($db, $college_id, $choice_pk_id, $choice_series, $sub_cat_col, $program_type, $subject_one, $subject_two, $subject_three);

            if ($SeatAllotmentRes == "ALLOTED") {


                $seat_alloted_flag = "1";
                $under_category_allotment = $cat_col . "-" . $sub_cat_col;
                $choice_alloted_series = $choice_series;
                /* Seat is alloted no need to read other choices */
                break;
            }
        }
    }

    $AddedDateTime = DATE('Y-m-d H:i:s');

    if ($seat_alloted_flag == "1") {
        $UpdateResult = array(
            "seat_allotment_status" => "10",
            "allotment_under_category" => "$under_category_allotment",
            "choice_series" => "$choice_series",
            "choice_pk_id" => "$choice_pk_id"
        );

        $db->update($UpdateResult, "itdc_result_tbl", "login_id='$LoginId' AND program_id='$ProgramId'");

        $SelProgram = array(
            "seat_allotment_status" => "10",
            "allotment_date" => "$AddedDateTime",
            "allotment_under_category" => "$under_category_allotment",
            "choice_series" => "$choice_series",
            "choice_pk_id" => "$choice_pk_id"
        );

        $db->update($SelProgram, "itdc_selected_program_tbl", "login_id='$LoginId' AND program_id='$ProgramId'");

        $SelectChoice = array(
            "seat_allotment_status" => "10"
        );

        $db->update($SelectChoice, "itdc_student_choice_tbl", "cid='$choice_pk_id' AND student_id='$LoginId' AND program_id='$ProgramId'");
    } else {

        /* Not Alloted */


        $SelProgram = array(
            "seat_allotment_status" => "30"
        );

        $db->update($SelProgram, "itdc_selected_program_tbl", "login_id='$LoginId' AND program_id='$ProgramId'");

        $db->update($SelProgram, "itdc_result_tbl", "login_id='$LoginId' AND program_id='$ProgramId'");
    }
}

/* Function is used to decide seat will be alloted or not */

function FunSubjectChoiceProcess($db, $college_id, $choice_pk_id, $choice_series, $cat_type_col, $program_type, $subject_one, $subject_two = "", $subject_three = "") {
    $Choice_One_status = "";
    $Choice_Two_status = "";
    $Choice_Three_status = "";

    if ($program_type == "three_subject") {

        $Choice_One_status = FunGettingSeat($db, $cat_type_col, $program_type, $subject_one);

        if ($Choice_One_status > 0) {
            $Choice_Two_status = FunGettingSeat($db, $cat_type_col, $program_type, $subject_two);

            if ($Choice_Two_status > 0) {
                $Choice_Three_status = FunGettingSeat($db, $cat_type_col, $program_type, $subject_three);
            }
        }
    } else if ($program_type == "one_group") {

        $Choice_One_status = FunGettingSeat($db, $cat_type_col, $program_type, $subject_one);
        $Choice_Two_status = 1;
        $Choice_Three_status = 1;
    } else if ($program_type == "only_college") {

        $Choice_One_status = FunGettingSeat($db, $cat_type_col, $program_type, $college_id);
        $Choice_Two_status = 1;
        $Choice_Three_status = 1;
    }


    if ($Choice_One_status > 0 && $Choice_Two_status > 0 && $Choice_Three_status > 0) {
        $Seat_alloted_cat = $cat_type_col;
        $Choice_Prefer_order = $choice_series;

        if ($program_type == "three_subject") {

            /* One Seat is reduced for each subject */
            $res_Choice_One_status = $Choice_One_status - 1;
            UpdateSeat($db, $res_Choice_One_status, $cat_type_col, $program_type, $subject_one);

            $res_Choice_Two_status = $Choice_Two_status - 1;
            UpdateSeat($db, $res_Choice_Two_status, $cat_type_col, $program_type, $subject_two);

            $res_Choice_Three_status = $Choice_Three_status - 1;
            UpdateSeat($db, $res_Choice_Two_status, $cat_type_col, $program_type, $subject_three);
        } else if ($program_type == "one_group") {
            /* One Seat is reduced for  group */
            $res_Choice_One_status = $Choice_One_status - 1;
            UpdateSeat($db, $res_Choice_One_status, $cat_type_col, $program_type, $subject_one);
        } else if ($program_type == "only_college") {

            $res_Choice_One_status = $Choice_One_status - 1;

            UpdateSeat($db, $res_Choice_One_status, $cat_type_col, $program_type, $college_id);
        }

        return "ALLOTED";
        /* Seat Alloted */
    } else {
        return "NOTALLOTED";
    }
}

/* Function is used to get number of seats */

function FunGettingSeat($db, $final_cat_col, $program_type, $RefId) {
    if ($program_type == "three_subject" || $program_type == "one_group") {
        $Seat_Avail_Arr = $db->selectWithCols("itdc_college_subject_c1_tbl", "$final_cat_col", "sid='$RefId'");
        $get_seat_val = $Seat_Avail_Arr['0'][$final_cat_col];
    } else if ($program_type == "only_college") {
        $Seat_Avail_Arr = $db->selectWithCols("itdc_college_list_c1_tbl", "$final_cat_col", "cid='$RefId'");
        $get_seat_val = $Seat_Avail_Arr['0'][$final_cat_col];
    }

    if (empty($get_seat_val) || $get_seat_val == NULL) {
        $get_seat_val = 0;
    }

    return $get_seat_val;
}

/* Function is used to  Update seats */

function UpdateSeat($db, $rem_seat_val, $final_cat_col, $program_type, $RefId) {

    if ($program_type == "three_subject" || $program_type == "one_group") {

        $data_arr = array("$final_cat_col" => "$rem_seat_val");

        $db->update($data_arr, "itdc_college_subject_c1_tbl", "sid='$RefId'");
    } else {
        $data_arr = array("$final_cat_col" => "$rem_seat_val");
        $db->update($data_arr, "itdc_college_list_c1_tbl", "cid='$RefId'");
    }
}

?>