$().ready(function () {
    $("#forgotpassword_formid").validate({
        rules: {
            forgot_mobile: {
                required: true,
                digits: true,
                minlength: 10,
                maxlength: 10,
                customphonenumbervalidation: true
            },
            date_birth: {
                required: true
            }
        },
        messages: {
            forgot_mobile: {
                required: "Please enter mobile number"
            },
            date_birth: {
                required: "Please enter date of birth"
            }
        },
        tooltip_options: {
            forgot_mobile: {
                placement: 'bottom',
                html: true
            },
            date_birth: {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function (form) {
            $('#forgot_processing').show();
            $('#forgot_submitbtn').hide();
            $('#forgotpassword_successerrormsgid').html('');
            $.post("forgot-password.php", $("#forgotpassword_formid").serialize(), function (data) {
                $('#forgot_processing').hide();
                $('#forgot_submitbtn').show();
                data = data.trim();
                if (data == '10') {
                    $('#forgot_mobile').val('');
                    $('#forgotpassword_successerrormsgid').html('<div class="alert alert-success text-center" style="">Password sent to your registered mobile number & Email Id.</div>');
                } else if (data == '20') {
                    $('#forgotpassword_successerrormsgid').html('<div class="alert alert-danger text-center" style="">You have entered the wrong mobile number or date of birth.</div>');
                } else if (data == '30') {
                    $('#forgotpassword_successerrormsgid').html('<div class="alert alert-danger text-center" style="">Please enter valid mobile number.</div>');
                }
            });
        }
    });

    $("#accountverification_formid").validate({
        rules: {
            verification_code: {
                required: true,
                digits: true,
                minlength: 4,
                maxlength: 4,
                customphonenumbervalidation: true
            }
        },
        messages: {
            verification_code: {
                required: "Please enter your verification code"
            }
        },
        tooltip_options: {
            verification_code: {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function (form) {
            var lo = new ajaxLoader('.pageloader');
            $.post("account-verification.inc.php", $("#accountverification_formid").serialize(), function (data) {
                data = data.trim();
                var login_program = $('#login_program').val();
                if (data == '10') {
                    if (login_program == 'ugp') {
                        window.location = '../ugp/index.php';
                    } else if (login_program == 'pgp') {
                        window.location = '../pgp/index.php';
                    } else if (login_program == 'med') {
                        window.location = '../med/index.php';
                    } else if (login_program == 'med') {
                        window.location = '../med/index.php';
                    }
                } else if (data == '20') {
                    $('#errorsuc_msgdivid').html('<div class="alert alert-danger text-center" style="">Invalid Verification Code.</div>');
                }
                lo.remove();
            });
        }
    });

    $("#mverification_formid").validate({
        rules: {
            verification_code: {
                required: true,
                digits: true,
                minlength: 6,
                maxlength: 6,
                customphonenumbervalidation: true
            }
        },
        messages: {
            verification_code: {
                required: "Please enter your verification code"
            }
        },
        tooltip_options: {
            verification_code: {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function (form) {
            var lo = new ajaxLoader('.pageloader');
            $.post("mverification.inc.php", $("#mverification_formid").serialize(), function (data) {
                data = data.trim();
                var login_program = $('#login_program').val();
                if (data == '10') {
//                    alert(login_program);
                    if (login_program == 'ugp') {
                        window.location = '../ugp/mindex.php';
                    } else if (login_program == 'pgp') {
                        window.location = '../pgp/mindex.php';
                    } else if (login_program == 'BLISC') {
                        window.location = '../blisc/mindex.php';
                    } else if (login_program == 'MBA') {
                        window.location = '../mba/mindex.php';
                    }
                } else if (data == '20') {
                    $('#errorsuc_msgdivid').html('<div class="alert alert-danger text-center" style="">Invalid Verification Code.</div>');
                }
                lo.remove();
            });
        }
    });

    $("#medregister_formid").validate({
        rules: {
            student_name: {
                required: true,
                customvalidation: true
            },
            father_name: {
                required: true,
                customvalidation: true
            },
            mother_name: {
                required: true,
                customvalidation: true
            },
            mobile_number: {
                required: true,
                digits: true,
                minlength: 10,
                maxlength: 10,
                customphonenumbervalidation: true
            },
            email_id: {
                required: true,
                email: true
            },
            program: {
                required: true
            },
            date_birth: {
                required: true
            },
            qualifying_examination: {
                required: true
            },
            status_aboveprogram: {
                required: true
            },
            total_max_marks: {
//                required: true,
//                digits: true,
//                customphonenumbervalidation: true
            },
            total_obtained_marks: {
//                required: true,
//                digits: true,
//                customphonenumbervalidation: true
            },
            category: {
                required: true
            },
            verif_box: {
                required: true,
                digits: true,
                minlength: 6,
                maxlength: 6
            },
            brochure: {
                required: true
            },
            password: {
                required: true

            },
            confirm_password: {
                required: true,
                equalTo: "#password"
            }
        },
        messages: {
            student_name: {
                required: "Please enter name."
            },
            father_name: {
                required: "Please enter father name."
            },
            mother_name: {
                required: "Please enter mother name."
            },
            mobile_number: {
                required: "Please enter mobile number."
            },
            email_id: {
                required: "Please enter email id."
            },
            program: {
                required: "Please select program."
            },
            date_birth: {
                required: "Please enter date of birth."
            },
            qualifying_examination: {
                required: "Please select qualifying examination."
            },
            status_aboveprogram: {
                required: "Please select status."
            },
            total_max_marks: {
                required: "Please enter max marks."
            },
            total_obtained_marks: {
                required: "Please enter obtained marks."
            },
            category: {
                required: "Please select category."
            },
            verif_box: {
                required: "Please enter captcha."
            },
            brochure: {
                required: "Please checked."
            },
            password: {
                required: "Please enter password."
            },
            confirm_password: {
                required: "Please enter password."
            }
        },
        tooltip_options: {
            student_name: {
                placement: 'bottom',
                html: true
            },
            father_name: {
                placement: 'bottom',
                html: true
            },
            mother_name: {
                placement: 'bottom',
                html: true
            },
            mobile_number: {
                placement: 'bottom',
                html: true
            },
            email_id: {
                placement: 'bottom',
                html: true
            },
            program: {
                placement: 'bottom',
                html: true
            },
            date_birth: {
                placement: 'bottom',
                html: true
            },
            qualifying_examination: {
                placement: 'bottom',
                html: true
            },
            status_aboveprogram: {
                placement: 'bottom',
                html: true
            },
            total_max_marks: {
                placement: 'bottom',
                html: true
            },
            total_obtained_marks: {
                placement: 'bottom',
                html: true
            },
            category: {
                placement: 'bottom',
                html: true
            },
            verif_box: {
                placement: 'bottom',
                html: true
            },
            brochure: {
                placement: 'bottom',
                html: true
            },
            password: {
                placement: 'bottom',
                html: true
            },
            confirm_password: {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function (form) {
            $('#registration_errordivid').hide();
            $('#registrationform_submitbtn').hide();
            $('#processing_divid').show();
            $.post("index.inc.php", $("#medregister_formid").serialize(), function (data) {
                var data = $.trim(data);

                var data_arr = data.split("<!explode>");
                if (data_arr[0] == '20') {
                    $('#registration_errordivid').show();
                    $('#registration_errormsgid').html(data_arr[1]);
                } else if (data_arr[0] == '10') {
                    $('#registration_divid').hide();
                    $('#registration_successmsgid').show();
                    window.location = 'account-verification.php?sid=' + data_arr[1];
                } else if (data_arr[0] == '30') {
                    window.location = 'account-verification.php?sid=' + data_arr[1];
                }
                $('#processing_divid').hide();
                $('#registrationform_submitbtn').show();
            });
        }
    });
    $("#medlogin_formid").validate({
        rules: {
            login_mobilenumber: {
                required: true,
                digits: true,
                minlength: 10,
                maxlength: 10,
                customphonenumbervalidation: true
            },
            login_pwd: {
                required: true
            },
            login_verif_box: {
                required: true,
                digits: true,
                minlength: 6,
                maxlength: 6
            },
            login_brochure: {
                required: true
            }
        },
        messages: {
            login_mobilenumber: {
                required: "Please enter mobile number"
            },
            login_pwd: {
                required: "Please enter password"
            },
            login_verif_box: {
                required: "Please enter captcha."
            },
            login_brochure: {
                required: "Please checked."
            }
        },
        tooltip_options: {
            login_mobilenumber: {
                placement: 'bottom',
                html: true
            },
            login_pwd: {
                placement: 'bottom',
                html: true
            },
            login_verif_box: {
                placement: 'bottom',
                html: true
            },
            login_brochure: {
                placement: 'bottom',
                html: true
            }
        },
        submitHandler: function (form) {
            $('#login_errordivid').hide();
            $.post("index.inc.php", $("#medlogin_formid").serialize(), function (data) {
                var data = $.trim(data);
                var data_arr = data.split("<!explode>");
                if (data_arr[0] == '20') {
                    $('#login_errordivid').show();
                    $('#login_errormsgid').html(data_arr[1]);
                } else if (data_arr[0] == '10') {
                    var login_program = $('#login_program').val();
                    $('#login_successmsgid').show();
                    window.location = '../med/index.php';
                } else if (data_arr[0] == '30') {
                    window.location = 'account-verification.php?sid=' + data_arr[1];
                }
            });
        }
    });

    $.validator.addMethod("customvalidation",
            function (value, element) {
                return /^[A-Za-z. ]+$/.test(value);
            },
            "Sorry, no special characters allowed"
            );

    $.validator.addMethod("customalphanumbervalidation",
            function (value, element) {
                if (value !== "") {
                    return /^[A-Za-z0-9]+$/.test(value);
                } else {
                    return true;
                }
            },
            "Sorry, no special characters allowed"
            );

    $.validator.addMethod("customphonenumbervalidation",
            function (value, element) {
                if (value !== "") {
                    return /^[0-9+.]+$/.test(value);
                } else {
                    return true;
                }
            },
            "Sorry, only numbers allowed"
            );

});