<?php

class common {

    public static function StrToDB($str) {
        $str = str_replace("'", "&#39;", $str);
        $str = str_replace('"', "&#34;", $str);
        $str = str_replace("\n", "&#nl", $str);
        $str = str_replace("<br/>", "&#rl", $str);

        return $str;
    }

    public static function StrFromDb($str) {
        $str = str_replace("&#39;", "'", $str);
        $str = str_replace("&#34;", '"', $str);
        $str = str_replace("&#nl", "\n", $str);
        $str = str_replace("&#rl", "<br/>", $str);

        return $str;
    }

    public static function TextarDb($str) {
        $str = str_replace("&#nl", "<br/>", $str);
        $str = str_replace("&#rl", "\r", $str);
        return $str;
    }

    public function humanTiming($time) {
        $time = time() - $time; // to get the time since that moment
        $tokens = array(
            31536000 => 'year',
            2592000 => 'month',
            604800 => 'week',
            86400 => 'day',
            3600 => 'hour',
            60 => 'minute',
            1 => 'second'
        );
        foreach ($tokens as $unit => $text) {
            if ($time < $unit)
                continue;
            $numberOfUnits = floor($time / $unit);
            return $numberOfUnits . ' ' . $text . (($numberOfUnits > 1) ? 's' : '');
        }
    }

    public function IND_money_format($money) {
        $len = strlen($money);
        $m = '';
        $money = strrev($money);
        for ($i = 0; $i < $len; $i++) {
            if (( $i == 3 || ($i > 3 && ($i - 1) % 2 == 0) ) && $i != $len) {
                $m .= ',';
            }
            $m .= $money[$i];
        }
        return strrev($m);
    }

    public function DecimalAmount($s_value) {
        $regex = '/^\s*[+\-]?(?:\d+(?:\.\d*)?|\.\d+)\s*$/';
        return preg_match($regex, $s_value);
    }

    public static function DecimalTwoPlace($number) {
        return number_format((float) $number, 2, '.', '');
    }

    public function rndfunc($x) {
        // Multiple Of 0.05
        return round($x * 2, 1) / 2;
    }

    public function fun_encrypt_str($id) {
        $random_number = mt_rand(11111111, 99999999);
        $pos = mt_rand(1, 8);
        $str = substr($random_number, 0, $pos) . $id . substr($random_number, $pos) . $pos;

        return $str;
    }

    public function fun_decrypt_str($str) {

        $total_length_string = strlen($str);
        $get_pos_val = substr($str, $total_length_string - 1);

        $id_length = $total_length_string - 9;

        $final_string = substr($str, $get_pos_val, $id_length);

        return $final_string;
    }

    public function CalculateHAOHLC($ha_open_p, $ha_close_p, $open_c, $high_c, $low_c, $close_c) {

        $ha_open_val = ($ha_open_p + $ha_close_p) / 2;
        $ha_close_val = ($open_c + $high_c + $low_c + $close_c) / 4;
        $ha_high_val = max($high_c, $ha_open_val, $ha_close_val);
        $ha_low_val = min($low_c, $ha_open_val, $ha_close_val);


        return $ha_open_val . "<>" . $ha_high_val . "<>" . $ha_low_val . "<>" . $ha_close_val;
    }

    public static function PasswordCheckCondition($passwordStr) {

        // Validate password strength
        $uppercase = preg_match('@[A-Z]@', $passwordStr);
        $lowercase = preg_match('@[a-z]@', $passwordStr);
        $number = preg_match('@[0-9]@', $passwordStr);
//        $specialChars = preg_match('@[^\w]@', $passwordStr);
        //
        $specialChars = preg_match('/[#!$%^&@*()_+=\-\[\],.\/{}|:;<>?~\\\\]/', $passwordStr);

        if (!$uppercase || !$lowercase || !$number || !$specialChars || strlen($passwordStr) < 8 || strlen($passwordStr) > 12) {
            //echo 'Please use 8-12 characters. Password should not be the same as your name or email. Use at least 1 number, 1 capital letter, and 1 special character.';

            return "2";
        } else {
            //echo 'Strong password.';

            return "1";
        }
    }

    public static function CleanSplChar($string) {
        $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
        return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
    }

    public static function GetAmountInWord($number) {
        $decimal = round($number - ($no = floor($number)), 2) * 100;
        $hundred = null;
        $digits_length = strlen($no);
        $i = 0;
        $str = array();
        $words = array(0 => '', 1 => 'one', 2 => 'two',
            3 => 'three', 4 => 'four', 5 => 'five', 6 => 'six',
            7 => 'seven', 8 => 'eight', 9 => 'nine',
            10 => 'ten', 11 => 'eleven', 12 => 'twelve',
            13 => 'thirteen', 14 => 'fourteen', 15 => 'fifteen',
            16 => 'sixteen', 17 => 'seventeen', 18 => 'eighteen',
            19 => 'nineteen', 20 => 'twenty', 30 => 'thirty',
            40 => 'forty', 50 => 'fifty', 60 => 'sixty',
            70 => 'seventy', 80 => 'eighty', 90 => 'ninety');
        $digits = array('', 'hundred', 'thousand', 'lakh', 'crore');
        while ($i < $digits_length) {
            $divider = ($i == 2) ? 10 : 100;
            $number = floor($no % $divider);
            $no = floor($no / $divider);
            $i += $divider == 10 ? 1 : 2;
            if ($number) {
                $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                $str [] = ($number < 21) ? $words[$number] . ' ' . $digits[$counter] . $plural . ' ' . $hundred : $words[floor($number / 10) * 10] . ' ' . $words[$number % 10] . ' ' . $digits[$counter] . $plural . ' ' . $hundred;
            } else
                $str[] = null;
        }
        $Rupees = implode('', array_reverse($str));
        $paise = ($decimal) ? " " . ($words[$decimal / 10] . " " . $words[$decimal % 10]) . ' Paise' : '';
        return $Rupees . " " . $paise . " Only";
    }

    public function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function cUrlGetData($url, $post_fields = null, $headers = null) {

        $ch = curl_init();
        $timeout = 5;
        curl_setopt($ch, CURLOPT_URL, $url);

        if (!empty($post_fields)) {

            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
        }

        if (!empty($headers))
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 1);
        // curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
        //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        $data = curl_exec($ch);

        if (curl_errno($ch)) {

            echo 'Error:' . curl_error($ch);
        }

        curl_close($ch);
        return $data;
    }

}

?>