<?php
ob_start();
include_once 'classes/common.php';
include_once 'classes/DB.class.php';
include_once 'session/admin-session.php';
ini_set("display_errors", 0);
$db = new DB();

$added_by = $_SESSION['gftgn_admin_id'];

/* Getting Occasions List */
$Occasion_list_arr = $db->selectWithCols("gftgn_occasions_tbl", "*", "1 AND status='1' ORDER BY occasion_name ASC");

/* Getting Category List */
$Category_list_arr = $db->selectWithCols("gftgn_category_tbl", "*", "1 AND status='1' ORDER BY category_name ASC");
?>
<style type="text/css">
            .image-container {
                display: flex;
                flex-wrap: wrap;
                gap: 10px;
            }
            .image-wrapper {
                position: relative;
                display: inline-block;
            }
            .image-wrapper img {
                width: 100px;
                height: 100px;
                object-fit: cover;
                border-radius: 5px;
            }
            .remove-btn {
                position: absolute;
                top: 5px;
                right: 5px;
                background-color: red;
                color: white;
                border: none;
                border-radius: 50%;
                width: 20px;
                height: 20px;
                font-size: 14px;
                cursor: pointer;
                display: flex;
                align-items: center;
                justify-content: center;
            }
        </style>
<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12 ">
        <h3>Enter The Product</h3>
        <div class="box box-primary">
            <div class="box-body">
                <div class="row" id="result_msg" style="padding-left: 5px;"></div>
                <form action="" method="POST" id="product_form_id" enctype="multipart/form-data">
                    <div class="row">
                        <div class="col-md-6 col-sm-6 col-xs-6">
                            <div class="form-group">
                                <label>Product Title<font color="red">*</font></label>
                                <input type="text" name="product_title" id="product_title" class="form-control input-lg" required="" placeholder="Enter The Product Title"/>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-xs-6">
                            <div class="form-group">
                                <label>Product Price<font color="red">*</font></label>
                                <input type="text" name="product_price" id="product_price" class="form-control input-lg" required="" placeholder="Enter The Product Actual Price"/>
                                <i style="font-size: 10px;">(*Product Actual Price)</i>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-xs-6">
                            <div class="form-group">
                                <label>Product Offer Price<font color="red">*</font></label>
                                <input type="text" name="product_offer_price" id="product_offer_price" class="form-control input-lg" required="" placeholder="Enter The Product Sold Price"/>
                                <i style="font-size: 10px;">(*Actual Sold Price)</i>
                            </div>
                        </div>

                        <div class="clearfix"></div>
                        <div class="col-md-3 col-sm-6 col-xs-6">
                            <div class="form-group">
                                <label>Choose Occasions<font color="red">*</font></label>
                                <select name="occasion_pk_id[]" id="occasion_pk_id" class="form-control input-lg" multiple="">
                                    <?php foreach ($Occasion_list_arr as $OLA) { ?>
                                        <option value="<?php echo $OLA['occasion_pk_id']; ?>"><?php echo $OLA['occasion_name']; ?></option>
                                    <?php } ?>
                                </select>
                                <i style="font-size: 10px;">(You can select more than one OCCASIONS)</i>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-xs-6">
                            <div class="form-group">
                                <label>Choose Category<font color="red">*</font></label>
                                <select name="category_pk_id[]" id="category_pk_id" class="form-control input-lg" multiple="">
                                    <?php foreach ($Category_list_arr as $CLA) { ?>
                                        <option value="<?php echo $CLA['category_pk_id']; ?>"><?php echo $CLA['category_name']; ?></option>
                                    <?php } ?>
                                </select>
                                <i style="font-size: 10px;">(You can select more than one CATEGORY)</i>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-xs-6">
                            <div class="form-group">
                                <label>Choose Sub Category<font color="red">*</font></label>
                                <select name="sub_category_pk_id[]" id="sub_category_pk_id" class="form-control input-lg" multiple="">

                                </select>
                                <i style="font-size: 10px;">(You can select more than one Sub-CATEGORY)</i>
                            </div>
                        </div>
                        
                               <div class="col-md-3 col-sm-6 col-xs-6">
                            <div class="form-group">
                                <label>Customization Allow<font color="red">*</font></label>
                                <select name="customization_allow" id="customization_allow" class="form-control input-lg" required="">
                                    <option value="">Select Option</option>
                                    <option value="YES">YES</option>
                                    <option value="NO">NO</option>
                                </select>
                                
                            </div>
                        </div>

                        <div class="col-md-12 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Product Description<font color="red">*</font></label>
                                <textarea name="product_description_text" id="product_description_text" class="form-control input-lg"></textarea>

                            </div>
                        </div>
                        <div class="clearfix"></div>

                        <div class="col-md-12 col-sm-12 col-xs-12">
                            <div class="form-group">
                                <label>Image Upload<font color="red">*</font></label>
                                <input type="file" name="file_image_upload[]" id="file_image_upload" value="" accept=".jpg,.png,.jpeg,.webp" multiple/>

                            </div>
                        </div>
                        <div class="col-md-12 col-sm-12 col-xs-12 image-container" id="imageContainer">
                       
                        </div>

                        <div class="col-md-2 col-sm-2 col-xs-2">
                            <div class="form-group">
                                <label><br/></label>
                                <input type="hidden" name="action" id="action" value="gft-product-entry"/>
                                <input type="hidden" name="added_by" id="added_by" value="<?php echo $added_by; ?>"/>
                                <input type="submit" name="product_add_btn" id="product_add_btn" class="btn btn-warning btn-block text-uppercase" value="SAVE & CONTINUE"/ style="width: 181px;">
                            </div>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>
<div class="clearfix"></div><br/><br/>
<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include 'admin-master.php';
?>
<script type="text/javascript">
    $(function () {
        $("#category_pk_id").change(function () {
            var category_id_str = $(this).val();
            $.ajax({
                type: "POST",
                url: "server/action-post.php",
                data: "category_id_str=" + category_id_str + "&action=GetSubCategory",
                success: function (data) {
                    $("#sub_category_pk_id").html(data.data);
                }
            });

        });

        /*Upload Image of Gift*/
        $('#file_image_upload').on('change', function (event) {
            const files = event.target.files;

            // Loop through each selected file
            for (let i = 0; i < files.length; i++) {
                const reader = new FileReader();

                // When the file is loaded, create the image element
                reader.onload = function (e) {
                    const imgSrc = e.target.result;
                    const imgWrapper = $('<div class="image-wrapper"></div>');
                    const img = $('<img>').attr('src', imgSrc);

                    // Create the remove button and add it to the image wrapper
                    const removeBtn = $('<button class="remove-btn">X</button>');
                    removeBtn.on('click', function () {
                        imgWrapper.remove(); // Remove the image wrapper
                    });
                    
                    imgWrapper.append(img);
                    imgWrapper.append(removeBtn);
                    $('#imageContainer').append(imgWrapper); // Append to the image container
                };

                // Read the image file as a data URL
                reader.readAsDataURL(files[i]);
            }
        });
        
        /*Product Add*/
          
         $("#product_form_id").validate({
            rules: {
                product_title: {
                    required: true
                },
                product_price: {
                    required: true
                },
                product_offer_price: {
                    required: true
                },
                occasion_pk_id: {
                    required: true
                },
                category_pk_id: {
                    required: true
                },
                sub_category_pk_id: {
                    required: true
                },
                product_description_text: {
                    required: true
                },
                file_image_upload: {
                    required: true
                },
                customizaion_allow: {
                    required: true
                }
            },
            messages: {
                product_title: {
                    required: "Please Enter The Product Title"
                },
                product_price: {
                    required: "Please Enter The Product Price"
                },
                product_offer_price: {
                    required: "Please Enter The Offer Price"
                },
                occasion_pk_id: {
                    required: "Please Enter The Occasion"
                },
                category_pk_id: {
                    required: "Please Enter The Category"
                },
                sub_category_pk_id: {
                    required: "Please Enter The Sub Category"
                },
                product_description_text: {
                    required: "Please Enter Product Description"
                },
                file_image_upload: {
                    required: "Please Upload The File"
                },
                customization_allow: {
                    required: "Please Enter Customization Option"
                }
            }
        });
        $("#product_add_btn").click(function () {
            $("#result_msg").html("");
            if ($("#product_form_id").valid()) {
               var formData = new FormData($('#product_form_id')[0]);
                
                $.ajax({
                    type: "POST",
                    url: "server/action-post.php",
                    data: formData,
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function (data) {
                        if (data.res_status == 1) {
                            var ProductPkId = data.product_pk_id;
                            $("#result_msg").html("<span style='color: green;'>Product basic detail is added successfully!</span>");
                            window.location.href = "gft-product-entry-details.php?ProductPkId="+ProductPkId;
                        } else {
                            $("#result_msg").html("<span style='color: red;'>" + data.res_msg + "</span>");

                        }
                    }
                });
            }
            return false;
        });
    });
</script>