
/*
* Ajax overlay 1.0
* Author: Simon Ilett @ aplusdesign.com.au
* Descrip: Creates and inserts an ajax loader for ajax calls / timed events 
* Date: 03/08/2011 
*/
function ajaxLoader (el, options) {
   
    // Becomes this.options
    var defaults = {
        bgColor 		: '#ffffff',
        duration		: 800,
        opacity			: 0.9,
        classOveride 	: false
    }
    this.options 	= jQuery.extend(defaults, options);
    this.container 	= $(el);
	
    this.init = function() {
        var container = this.container;
        // Delete any other loaders
        this.remove(); 
        // Create the overlay 
        var overlay = $('<div></div>').css({
            'background-color': this.options.bgColor,
            'opacity': this.options.opacity,
          'position':' fixed',
   'top': 0,
    'left': 0,
   'width': '100%',
    'height': '100%',
   'z-index': 10000
        }).addClass('ajax_overlay');
        // add an overiding class name to set new loader style 
        if (this.options.classOveride) {
            overlay.addClass(this.options.classOveride);
        }
        // insert overlay and loader into DOM 
        container.append(
            overlay.append(
                $('<div></div>').addClass('ajax_loader')
                ).fadeIn(this.options.duration)
            );
    };
	
    this.remove = function(){
        var overlay = this.container.children(".ajax_overlay");
        if (overlay.length) {
            overlay.fadeOut(this.options.classOveride, function() {
                overlay.remove();
            });
        }	
    }

    this.init();
}	
	


