<?php

header("Content-Type: application/json; charset=utf-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: PUT, GET, POST");
include_once '../classes/DB.class.php';
include_once '../classes/common.php';
include_once '../classes/validation.php';
require_once('../tcpdf/tcpdf.php');

class MYPDF extends TCPDF {

    public function Header() {
        $this->SetFont('helvetica', 'B', 8);
        $view_tbl .= '';
        $this->writeHTML($view_tbl, true, false, true, false, '');
        $this->Cell(0, 0, ' ', 0, false, 'C', 0, '', 0, false, 'M', 'M');
    }

    public function Footer() {

        $this->SetY(-50);

        $this->SetFont('helvetica', 'I', 8);

        $view_tbl .= '';
        $this->writeHTML($view_tbl, true, false, true, false, '');
        $this->Cell(0, 0, ' ', 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

ini_set("display_errors", 0);

$db = new DB();
$val = new validation();
$com = new common();

$action = empty($_POST["action"]) ? "" : $_POST["action"];
$added_by = empty($_POST["added_by"]) ? "" : $_POST["added_by"];

$added_date = DATE('Y-m-d H:i:s');

if ($action == "") {
    $arr["res_status"] = "2";
    $arr["res_msg"] = "Source Not Found!";
} else {

    switch ($action) {
        case "gft-product-entry":

            $product_title = empty($_POST["product_title"]) ? "" : common::StrToDB($_POST["product_title"]);
            $product_price = empty($_POST["product_price"]) ? "" : common::StrToDB($_POST["product_price"]);
            $product_offer_price = empty($_POST["product_offer_price"]) ? "" : common::StrToDB($_POST["product_offer_price"]);
            $occasion_pk_id_arr = empty($_POST["occasion_pk_id"]) ? array() : $_POST["occasion_pk_id"];
            $category_pk_id_arr = empty($_POST["category_pk_id"]) ? array() : $_POST["category_pk_id"];
            $sub_category_pk_id_arr = empty($_POST["sub_category_pk_id"]) ? array() : $_POST["sub_category_pk_id"];
            $customization_allow = empty($_POST["customization_allow"]) ? "" : $_POST["customization_allow"];
            $product_description_text = empty($_POST["product_description_text"]) ? "" : $_POST["product_description_text"];
            $file_image_upload_arr = empty($_FILES['file_image_upload']['name']) ? "" : $_FILES['file_image_upload']['name'];
           
            $added_by = empty($_POST['added_by']) ? "" : $_POST['added_by'];

            if (count($occasion_pk_id_arr) > 0) {
                $occasion_pk_id_str = implode(",", $occasion_pk_id_arr);
            }

            if (count($category_pk_id_arr) > 0) {
                $category_pk_id_str = implode(",", $category_pk_id_arr);
            }

            if (count($sub_category_pk_id_arr) > 0) {
                $sub_category_pk_id_str = implode(",", $sub_category_pk_id_arr);
            }


            if (count($file_image_upload_arr)) {

                $uploadDir = "../../guplod/prodimg/";
                $error_flag = 1;
                $error_msg = "";
                $file_image_str = "";
                foreach ($_FILES['file_image_upload']['name'] as $key => $filename) {
                    // Check for upload errors
                    if ($_FILES['file_image_upload']['error'][$key] == UPLOAD_ERR_OK) {
                        // Generate a unique name for the uploaded file
                        $tempName = $_FILES['file_image_upload']['tmp_name'][$key];
                        $fileSize = $_FILES['file_image_upload']['size'][$key];
                        $fileType = $_FILES['file_image_upload']['type'][$key];

                        $filename_org = $filename;
                        $filename = mt_rand("11111", "99999") . "_" . $filename;
                        $newFilePath = $uploadDir . basename($filename);

                        $maxFileSize = 2 * 1024 * 1024; // 2MB
                        // Check if the file size is greater than 2MB
                        if ($fileSize > $maxFileSize) {
                            // Handle image compression if it's an image
                            if (in_array($fileType, ['image/jpeg', 'image/png', 'image/gif'])) {
                                $compressedImagePath = $uploadDir . basename($filename);
                                // Compress the image while maintaining aspect ratio
                                if ($com->compressImage($tempName, $compressedImagePath, $fileType)) {
                                    $file_image_str .= $filename . ",";
                                    // echo "File " . htmlspecialchars($filename) . " compressed and uploaded successfully.<br>";
                                } else {
                                    $error_flag = 2;
                                    $error_msg .= "Error Compressing File: " . $filename_org . "<br/>";
                                    // echo "Error compressing file " . htmlspecialchars($filename) . ".<br>";
                                }
                            } else {
                                $error_flag = 2;
                                $error_msg .= "Not An Image File: " . $filename_org . "<br/>";
                                // echo "File " . htmlspecialchars($filename) . " is not an image. Skipping compression.<br>";
                            }
                        } else {
                            // If the file size is less than or equal to 2MB, upload it without compression
                            $uploadPath = $uploadDir . basename($filename);
                            if (move_uploaded_file($tempName, $uploadPath)) {
                                $file_image_str .= $filename . ",";
                                //echo "File " . htmlspecialchars($filename) . " uploaded successfully.<br>";
                            } else {
                                $error_flag = 2;
                                $error_msg .= "Error Uploading File: " . $filename_org . "<br/>";
                                //echo "Error uploading file " . htmlspecialchars($filename) . ".<br>";
                            }
                        }
                    } else {
                        $error_flag = 2;
                        $error_msg .= "Error with file: " . $_FILES['file_image_upload']['error'][$key] . $filename_org . "<br/>";
                    }
                }
            }

            $productPkId = "";

            if ($error_flag == "1") {
                $InsertArr = array(
                    "product_name" => "$product_title",
                    "product_price" => "$product_price",
                    "product_offer_price" => "$product_offer_price",
                    "occasion_pk_id" => "$occasion_pk_id_str",
                    "category_pk_id" => "$category_pk_id_str",
                    "product_description_text" => "$product_description_text",
                    "customization_allow" => "$customization_allow",
                    "added_date" => "$added_date",
                    "product_image_file" => "$file_image_str",
                    "added_by" => "$added_by"
                );

                $productPkId = $db->insert($InsertArr, "gftgn_product_tbl");

                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
                $arr['product_pk_id'] = $productPkId;
            } else {
                $arr["res_status"] = "2";
                $arr["res_msg"] = $error_msg;
            }

            break;

        case "gft-coupon-entry":

            $added_date = DATE('Y-m-d H:i:s');

            $coupon_title = empty($_POST["coupon_title"]) ? "" : common::StrToDB($_POST["coupon_title"]);
            $coupon_code = empty($_POST["coupon_code"]) ? "" : common::StrToDB($_POST["coupon_code"]);
            $product_discount = empty($_POST["product_discount"]) ? "" : common::StrToDB($_POST["product_discount"]);
            $discount_type = empty($_POST["discount_type"]) ? "" : $_POST["discount_type"];
            $max_discount = empty($_POST["max_discount"]) ? "" : $_POST["max_discount"];
            $min_order_value = empty($_POST["min_order_value"]) ? "" : $_POST["min_order_value"];
            $order_frequency = empty($_POST["order_frequency"]) ? "" : $_POST["order_frequency"];
            $to_date = empty($_POST["to_date"]) ? "" : $_POST["to_date"];
            $from_date = empty($_POST["from_date"]) ? "" : $_POST["from_date"];
            $added_by = empty($_POST['added_by']) ? "" : $_POST['added_by'];

            $InsertArr = array(
                "coupon_title" => "$coupon_title",
                "coupon_code" => "$coupon_code",
                "discount" => "$product_discount",
                "discount_type" => "$discount_type",
                "max_discount" => "$max_discount",
                "min_order_value" => "$min_order_value",
                "frequency" => "$order_frequency",
                "from_date" => "$from_date",
                "to_date" => "$to_date",
                "added_by" => "$added_by",
                "added_date" => "$added_date"
            );

            $CouponPkId = $db->insert($InsertArr, "gftgn_coupon_tbl");

            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr['coupon_pk_id'] = $CouponPkId;

            break;

        case "gft-add-vendor":
            $vendor_full_name = empty($_POST["vendor_full_name"]) ? "" : common::StrToDB($_POST["vendor_full_name"]);
            $vendor_email_id = empty($_POST["vendor_email_id"]) ? "" : common::StrToDB($_POST["vendor_email_id"]);
            $vendor_phone_number = empty($_POST["vendor_phone_number"]) ? "" : common::StrToDB($_POST["vendor_phone_number"]);
            $city_id = empty($_POST["city_id"]) ? "" : common::StrToDB($_POST["city_id"]);

            /* Getting the City Name */
            $get_city_name_arr = $db->selectWithCols("gftgn_indian_cities_tbl", "city_name", "city_id='$city_id'");
            $city_name = $get_city_name_arr['0']['city_name'];

            $served_pin_code = empty($_POST["served_pin_code"]) ? "" : common::StrToDB($_POST["served_pin_code"]);

            $ins_vendor = array(
                "vendor_full_name" => "$vendor_full_name",
                "vendor_email_id" => "$vendor_email_id",
                "vendor_mobile_number" => "$vendor_phone_number",
                "vendor_city_pk_id" => $city_id,
                "vendor_city_name" => "$city_name",
                "pin_codes" => "$served_pin_code"
            );

            $VendorId = $db->insert($ins_vendor, "gftgn_vendor_tbl");

            if (!empty($VendorId)) {
                $arr["res_status"] = "1";
                $arr["vendor_pk_id"] = $VendorId;
                $arr["res_msg"] = "SUCCESS";
            } else {
                $arr["res_status"] = "2";
                $arr["res_msg"] = "Some Issue Occured!";
            }

            break;

        case "gft-product-details":

            $product_details = empty($_POST["product_details"]) ? "" : common::StrToDB($_POST["product_details"]);
            $added_by = empty($_POST["added_by"]) ? "" : common::StrToDB($_POST["added_by"]);
            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($product_details)) {

                $ins_details = array(
                    "product_pk_id" => "$ProductPkId",
                    "product_details_text" => "$product_details",
                    "added_by" => "$added_by",
                    "added_date" => "$added_date"
                );

                $db->insert($ins_details, "gftgn_product_prod_details_tbl");

                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }

            break;

        case "gft-product-details-list":

            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($ProductPkId)) {

                $ProductDetailsArr = $db->selectWithCols("gftgn_product_prod_details_tbl", "*", "product_pk_id='$ProductPkId'");

                $TrResData = "";
                $k = 1;
                foreach ($ProductDetailsArr as $PDA) {
                    $TrResData .= "<tr><td>" . $k . "</td><td>" . common::StrFromDb($PDA['product_details_text']) . "</td><td>--</td></tr>";
                    $k = $k + 1;
                }
                $arr['data'] = $TrResData;
                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }

            break;

        case "gft-product-ingredients":

            $ingredients = empty($_POST["ingredients"]) ? "" : common::StrToDB($_POST["ingredients"]);
            $added_by = empty($_POST["added_by"]) ? "" : common::StrToDB($_POST["added_by"]);
            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($ingredients)) {

                $ins_details = array(
                    "product_pk_id" => "$ProductPkId",
                    "ingredients_text" => "$ingredients",
                    "added_by" => "$added_by",
                    "added_date" => "$added_date"
                );

                $db->insert($ins_details, "gftgn_product_ingredients_tbl");

                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }


            break;

        case "gft-product-ingredient-list":

            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($ProductPkId)) {

                $IngredientDetailsArr = $db->selectWithCols("gftgn_product_ingredients_tbl", "*", "product_pk_id='$ProductPkId'");

                $TrResData = "";
                $k = 1;
                foreach ($IngredientDetailsArr as $PDA) {
                    $TrResData .= "<tr><td>" . $k . "</td><td>" . common::StrFromDb($PDA['ingredients_text']) . "</td><td>--</td></tr>";
                    $k = $k + 1;
                }
                $arr['data'] = $TrResData;
                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }

            break;

        case "gft-product-note":

            $note = empty($_POST["note"]) ? "" : common::StrToDB($_POST["note"]);
            $added_by = empty($_POST["added_by"]) ? "" : common::StrToDB($_POST["added_by"]);
            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($note)) {

                $ins_details = array(
                    "product_pk_id" => "$ProductPkId",
                    "note_text" => "$note",
                    "added_by" => "$added_by",
                    "added_date" => "$added_date"
                );

                $db->insert($ins_details, "gftgn_product_note_tbl");

                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }

            break;

        case "gft-note-list":

            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($ProductPkId)) {

                $ProductNoteArr = $db->selectWithCols("gftgn_product_note_tbl", "*", "product_pk_id='$ProductPkId'");

                $TrResData = "";
                $k = 1;
                foreach ($ProductNoteArr as $PDA) {
                    $TrResData .= "<tr><td>" . $k . "</td><td>" . common::StrFromDb($PDA['note_text']) . "</td><td>--</td></tr>";
                    $k = $k + 1;
                }
                $arr['data'] = $TrResData;
                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }

            break;

        case "gft-delivery-information":

            $delivery_information = empty($_POST["delivery_information"]) ? "" : common::StrToDB($_POST["delivery_information"]);
            $added_by = empty($_POST["added_by"]) ? "" : common::StrToDB($_POST["added_by"]);
            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($delivery_information)) {

                $ins_details = array(
                    "product_pk_id" => "$ProductPkId",
                    "delivery_information_text" => "$delivery_information",
                    "added_by" => "$added_by",
                    "added_date" => "$added_date"
                );

                $db->insert($ins_details, "gftgn_product_delivery_info_tbl");

                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }

            break;

        case "gft-delivery-info-list":
            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($ProductPkId)) {

                $ProductDeliveryArr = $db->selectWithCols("gftgn_product_delivery_info_tbl", "*", "product_pk_id='$ProductPkId'");

                $TrResData = "";
                $k = 1;
                foreach ($ProductDeliveryArr as $PDA) {
                    $TrResData .= "<tr><td>" . $k . "</td><td>" . common::StrFromDb($PDA['delivery_information_text']) . "</td><td>--</td></tr>";
                    $k = $k + 1;
                }
                $arr['data'] = $TrResData;
                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }

            break;

        case "gft-care-instrunction":

            $care_instruction = empty($_POST["care_instruction"]) ? "" : common::StrToDB($_POST["care_instruction"]);
            $added_by = empty($_POST["added_by"]) ? "" : common::StrToDB($_POST["added_by"]);
            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($care_instruction)) {

                $ins_details = array(
                    "product_pk_id" => "$ProductPkId",
                    "care_instrcution_text" => "$care_instruction",
                    "added_by" => "$added_by",
                    "added_date" => "$added_date"
                );

                $db->insert($ins_details, "gftgn_product_care_instruction_tbl");

                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }

            break;

        case "gft-care-list":

            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($ProductPkId)) {

                $ProductDeliveryArr = $db->selectWithCols("gftgn_product_care_instruction_tbl", "*", "product_pk_id='$ProductPkId'");

                $TrResData = "";
                $k = 1;
                foreach ($ProductDeliveryArr as $PDA) {
                    $TrResData .= "<tr><td>" . $k . "</td><td>" . common::StrFromDb($PDA['care_instrcution_text']) . "</td><td>--</td></tr>";
                    $k = $k + 1;
                }
                $arr['data'] = $TrResData;
                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }


            break;

        case "gft-manufacturer-details":

            $manufacturer_text = empty($_POST["manufacturer_details"]) ? "" : common::StrToDB($_POST["manufacturer_details"]);
            $added_by = empty($_POST["added_by"]) ? "" : common::StrToDB($_POST["added_by"]);
            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($manufacturer_text)) {

                $ins_details = array(
                    "product_pk_id" => "$ProductPkId",
                    "manufacturer_text" => "$manufacturer_text",
                    "added_by" => "$added_by",
                    "added_date" => "$added_date"
                );

                $db->insert($ins_details, "gftgn_product_manufacturer_tbl");

                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }

            break;

        case "gft-manufacturer-list":

            $ProductPkId = empty($_POST["ProductPkId"]) ? "" : common::StrToDB($_POST["ProductPkId"]);

            if (!empty($ProductPkId)) {

                $ProductDeliveryArr = $db->selectWithCols("gftgn_product_manufacturer_tbl", "*", "product_pk_id='$ProductPkId'");

                $TrResData = "";
                $k = 1;
                foreach ($ProductDeliveryArr as $PDA) {
                    $TrResData .= "<tr><td>" . $k . "</td><td>" . common::StrFromDb($PDA['manufacturer_text']) . "</td><td>--</td></tr>";
                    $k = $k + 1;
                }
                $arr['data'] = $TrResData;
                $arr["res_status"] = "1";
                $arr["res_msg"] = "SUCCESS";
            }


            break;

        case "GetSubCategory" :

            $category_id_str = $_REQUEST['category_id_str'];
            // Getting the List Of Sub Category
            $SubCateListArr = $db->selectWithCols("gftgn_sub_category_tbl", "sub_category_pk_id, sub_category_name", "1 AND status='1' AND category_pk_id IN ($category_id_str)");
            foreach ($SubCateListArr as $SLA) {
                $OptionVal .= "<option value='" . $SLA['sub_category_pk_id'] . "'>" . $SLA['sub_category_name'] . "</option>";
            }

            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            $arr["data"] = $OptionVal;
            break;

        case "ChangeOrderStatus" :

            $OrderPkId = $_REQUEST['OrderPkId'];
            $StatusVal = $_REQUEST['StatusVal'];

            $UpdateArr = array(
                "order_status" => "$StatusVal"
            );

            $db->update($UpdateArr, "gftgn_order_tbl", "order_pk_id='$OrderPkId'");

            $arr["res_status"] = "1";
            $arr["res_msg"] = "SUCCESS";
            break;
    }

    $RES = json_encode($arr);
    echo $RES;
}
?>