<?php
include_once '../session/admin-session.php';
include_once '../classes/class_admin.php';
include_once '../classes/validation.php';
include_once '../classes/common.php';
include_once 'read-configration.php';

ob_start();

$ObjDB = new class_db();
$objadm = new class_admin();
$val = new validation();

$SystemFlagArr = $objadm->MasterActiveBatchFlagSetting();

if ($_POST['reg_credit_btn']) {

    $batch_flag = $_REQUEST['batch_flag'];
    $batch_flag = $val->ValidateString($batch_flag);
    $objadm->batch = $batch_flag;

    $GetBatchArr = $objadm->GetStudentDetailsbyBatch();
}
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-xl-12 col-xxl-12 col-sm-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title">Registration Credit Count</h5>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-lg-2"></div>
                        <div class="col-lg-8">                        
                            <form action="" method="POST">
                                <div class="mb-3" style="padding-left: 0px;">
                                    <select class="form-select" id="batch_flag" name="batch_flag" required>
                                        <option value="">--- Select Batch ---</option>

                                        <?php
                                        while ($row = mysqli_fetch_array($SystemFlagArr)) {

                                            $batch = $row['flag_user'];
 $batch_year = "";
                                            if ($batch == 'b15') {
                                                $batch_year = 'BSMS 2020';
                                            }
                                            if ($batch == 'b16') {
                                                $batch_year = 'BSMS 2021';
                                            }
                                            if ($batch == 'b17') {
                                                $batch_year = 'BSMS 2022';
                                            }
                                            if ($batch == 'b18') {
                                                $batch_year = 'BSMS 2023';
                                            }
                                            if ($batch == 'b19') {
                                                $batch_year = 'BSMS 2024';
                                            }

                                            if ($batch == 'r13') {
                                                $batch_year = 'IPHD 2023';
                                            }
                                            if ($batch == 'r14') {
                                                $batch_year = 'IPHD 2024';
                                            }

                                            if ($batch == 'm2') {
                                                $batch_year = 'MSc 2023';
                                            }
                                            if ($batch == 'm3') {
                                                $batch_year = 'MSc 2024';
                                            }
                                            if(!empty($batch_year)){
                                                $selected_val = "";
                                                if($batch == $batch_flag){
                                                    $selected_val = "SELECTED";
                                                }
                                            ?>

                                            <option value="<?php echo $batch; ?>" <?php echo $selected_val; ?>><?php echo $batch_year; ?></option>

                                        <?php } 
                                        
                                        }
                                        ?>

                                    </select>

                                </div>

                                <input type="submit" class="btn btn-danger" style="background: #a9181b;
                                       border: #a9181b; text-align: center;" value="Submit" name="reg_credit_btn"/>

                            </form>

                        </div>
                        <div class="col-lg-2"></div><br/><br/>
                    </div>

                    <?php if ($_POST) { ?>
                        <div class="row">
                            <br/>
                            <div class="table-responsive">
                                <table class="table table-bordered align-middle" id="Subject_Credit_List">
                                    <thead class="table" style="background: #f3e4c1;" >
                                        <tr>
                                            <th>#</th>
                                            <th>Roll</th>
                                            <th>Name</th>
                                            <th>Count</th>
                                            <th>Credit</th>
                                            <th>Courses Registered</th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $cn = 1;
                                        $reg_file = 'isr_reg_' . $batch_flag . "_tbl";
                                        while ($rows = mysqli_fetch_array($GetBatchArr)) {
                                            $stu_roll = $rows['roll'];
                                            $stu_name = $rows['name'];
                                            $credit_taken = 0;
                                            $sub_taken = '';

                                            $qsub = "select a.sub_code, b.sub_crdit from $reg_file a, isr_curriculum_tbl b where a.stu_roll = '$stu_roll' and a.sub_code = b.sub_code and a.sub_list = b.sub_list and b1_sem = '$current_sem_num'";
                                            $ObjDB->sproc_name = $qsub;
                                            $res_str_val = $ObjDB->SelectQuery();

                                            $sub_reg = mysqli_num_rows($res_str_val);

                                            while ($rowq = mysqli_fetch_array($res_str_val)) {
                                                $credit_taken = $credit_taken + $rowq['sub_crdit'];
                                                $sub_taken = $sub_taken . ', ' . $rowq['sub_code'];
                                            }
                                            $sub_taken = substr($sub_taken, 2, 100);
                                            ?>
                                            <tr>
                                                <td><?php echo $cn; ?></td>
                                                <td><?php echo $stu_roll; ?></td>
                                                <td><?php echo $stu_name; ?></td>
                                                <td><?php echo $sub_reg; ?></td>
                                                <td><?php echo $credit_taken; ?></td>
                                                <td><?php echo $sub_taken; ?></td>
                                            </tr>

                                            <?php
                                            $cn = $cn + 1;
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php } ?>
                </div>

            </div>
        </div>
    </div>
</div>
<?php
$pagemaincontent = ob_get_contents();
ob_clean();
$PAGENAME = 'registration-credit-count';
$HTMLTITLE = '';
$HTMLDESCRIPTION = '';
$HTMLKEYWORDS = '';
include("admin-master.php");
?>
<script type="text/javascript">
    $("#Subject_Credit_List").DataTable({
        dom: '<"top"lBf>rt<"bottom"ip><"clear">',
        buttons: [
            {
                extend: 'excelHtml5',
                text: 'Download Excel',
                title: 'Data Export',
                className: 'btn btn-success'
            }
        ]
    });
</script>