<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/class_student.php';

$unique_code = $_GET['unique_code'] ?? '';
if (!$unique_code) die("Unique code not provided.");

$stuObj = new class_student();

// Fetch student courses for current semester to get subject info
$courses = $stuObj->GetStudentCourses(); // all active courses
$subject = null;
foreach ($courses as $c) {
    if ($c['unique_code'] === $unique_code) {
        $subject = $c;
        break;
    }
}

if (!$subject) die("Course not found.");

// Now get attendance using sub_code from the course
$sub_code = $subject['sub_code'] ?? '';
$summary = $stuObj->GetMyAttendance($sub_code);

$stu_roll = $summary['stu_roll'];
$attn_dates = $summary['attendance_dates'];
$attendance_data = $summary['attendance_data'];

ob_start();
?>
<section class="tpd-main pb-75">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="tpd-content-layout">
                    <div class="tp-dashboard-course-list">
                        <section class="tp-fact-wrapper">
                            <div class="tp-dashboard-section">
                                <h2 class="tp-dashboard-title">My Class Attendance</h2>
                                <h4 style="font-size: 18px;">
                                    Course: <?= htmlspecialchars($subject['sub_title'] ?? $sub_code) ?>
                                    <span style="float: right;">Classes Held: <?= count($attn_dates) ?></span>
                                </h4>
                            </div>

                            <div class="form-container" style="height: 400px;">
                                <div class="table-container">
                                    <table class="" style="height:100px;">
                                        <thead>
                                            <tr>
                                                <th>Sr</th>
                                                <th>Roll No.</th>
                                                <th>P</th>
                                                <th>E</th>
                                                <th>%</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $present_count = count(array_filter($attendance_data, fn($s) => $s === 'P'));
                                            $excused_count = count(array_filter($attendance_data, fn($s) => $s === 'E'));
                                            $total_classes = count($attn_dates);
                                            $percent = $total_classes ? round(($present_count / $total_classes) * 100) : 0;
                                            ?>
                                            <tr>
                                                <td>1</td>
                                                <td><?= htmlspecialchars($stu_roll) ?></td>
                                                <td><?= $present_count ?></td>
                                                <td><?= $excused_count ?></td>
                                                <td><?= $percent ?>%</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </section>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'class_attendance';
include("./student-masters.php");
?>
