<?php
ob_start();
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/common.php';
include_once __DIR__ . '/../classes/validation.php';
include_once __DIR__ . '/../classes/class_db.php';
include_once __DIR__ . '/../classes/class_student.php';
$studentObj = new class_student();
$stu_roll = $_SESSION['user_roll'] ?? '';
$current_sem = $studentObj->GetCurrentSemester($stu_roll);
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['drop_code'])) {
    $drop_code = $_POST['drop_code'];
    $studentObj->MoveToDroppedCourses($stu_roll, $drop_code);
}

$active_courses   = $studentObj->GetStudentCourses($stu_roll, $current_sem, "active");
$dropped_courses  = $studentObj->GetStudentCourses($stu_roll, $current_sem, "dropped"); 
?>
<style>
   td {
      padding: 1px 4px;
      border: 1px solid #d1c8b6;
      padding: 0.5rem 0.5rem;
   }</style>
<div class="tp-dashboard-course-list" >

    <!-- Drop Courses Section -->
    <section class="tp-fact-wrapper">
        <div class="row">
            <div class="col-lg-12">
                <div class="tp-dashboard-section">
                    <h2 class="tp-dashboard-title">Drop a Course</h2>
                </div>
            </div>
        </div>

        <div class="">
            <?php if (!empty($active_courses)) { ?>
            <form method="post" action="">
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Course Code</th>
                                <th>Course Title</th>
                                <th>Credit</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($active_courses as $i => $course) { ?>
                            <tr>
                                <td><?php echo $i + 1; ?></td>
                                <td><?php echo htmlspecialchars($course['sub_code']); ?></td>
                                <td><?php echo htmlspecialchars($course['sub_title']); ?></td>
                                <td><?php echo htmlspecialchars($course['sub_crdit']); ?></td>
                                <td>
                                    <button type="submit" name="drop_code" 
                                            value="<?php echo $course['unique_code']; ?>"
                                            onclick="return confirm('Are you sure you want to drop this course?')">
                                        Drop
                                    </button>
                                </td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </form>
            <?php } else { ?>
                <p>No active courses to drop.</p>
            <?php } ?>
        </div>
    </section>

    <!-- Dropped Courses Section -->
    <section class="tp-fact-wrapper">
        <div class="row">
            <div class="col-lg-12">
                <div class="tp-dashboard-section" style="    margin-top: 20px;">
                    <h2 class="tp-dashboard-title">Dropped Courses</h2>
                </div>
            </div>
        </div>

        <div class="">
            <?php if (!empty($dropped_courses)) { ?>
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Course Code</th>
                                <th>Course Title</th>
                                <th>Credit</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($dropped_courses as $i => $course) { ?>
                            <tr>
                                <td><?php echo $i + 1; ?></td>
                                <td><?php echo htmlspecialchars($course['sub_code']); ?></td>
                                <td><?php echo htmlspecialchars($course['sub_title']); ?></td>
                                <td><?php echo htmlspecialchars($course['sub_crdit']); ?></td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            <?php } else { ?>
                <p>No courses have been dropped yet.</p>
            <?php } ?>
        </div>
    </section>

</div>

<?php
// Include main template
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'student_feedback';
include("./student-masters.php");
?>
