<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/common.php';
include_once __DIR__ . '/../classes/validation.php';
include_once __DIR__ . '/../classes/class_student.php';
$validate = new validation();
if (empty($_SESSION['user_roll'])) {
    header("Location: login.php");
    exit;
}
$stu_roll = $validate->ValidateString($_SESSION['user_roll']);
$unique_code = isset($_GET['code']) ? $validate->ValidateString($_GET['code']) : '';
if (empty($unique_code)) {
    $_SESSION['flash_msg'] = "Invalid course code.";
    header("Location: feedback.php");
    exit;
}
try {
    $feedbackObj = new class_midsem_feedback($stu_roll, $unique_code);
    $feedbackObj->validateCode();
    $feedbackObj->handleAbstain();
} catch (Exception $e) {
    $_SESSION['flash_msg'] = $e->getMessage();
    header("Location: feedback.php");
    exit;
}
?>
