<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/class_student.php';

$stu_roll    = $_SESSION['user_roll'] ?? '';
$unique_code = $_GET['code'] ?? '';

try {
    if (empty($stu_roll)) {
        throw new Exception("Student not logged in!");
    }

    if (empty($unique_code)) {
        throw new Exception("Invalid course selection!");
    }

    $feedback = new class_midsem_feedback($stu_roll, $unique_code);
    $feedback->validateCode();
    $feedback->fetchCourse();
    $feedback->fetchQuestions();
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $responses = [];
        foreach ($feedback->questions as $idx => $q) {
            $responses[] = $_POST['question_' . ($idx + 1)] ?? '';
        }

        $comment = $_POST['comments'] ?? '';
        $feedback->InsertMidsemFeedback(
            $stu_roll,
            $feedback->course['b1_sem'],
            $feedback->course['batch'] ?? '',
            $feedback->course['sub_list'],
            $feedback->course['sub_code'],
            $feedback->course['fac_code'],
            $responses,
            $comment
        );

        $feedback->msg = "Mid Semester Feedback submitted successfully!";
        $_SESSION['flash_msg'] = $feedback->msg;
    }
} catch (Exception $e) {
    die("<div style='color:red;font-weight:bold;'>" . $e->getMessage() . "</div>");
}

ob_start();
?>
<!-- dashboad-content-box-area-start -->
<div class="tp-dashboard-course-list">
   <section class="tp-fact-wrapper">
      <div class="row">
         <div class="col-lg-12">
            <div class="tp-dashboard-section">
               <h2 class="tp-dashboard-title">Mid Semester Feedback</h2>
            </div>
         </div>
      </div>

      <div class="container mt-4">
         <?php if (!empty($feedback->msg)) : ?>
            <div class="alert alert-success text-center"><?= $feedback->msg ?></div>
         <?php endif; ?>

         <?php if (!empty($feedback->course)) : ?>
         <div class="table mt-3">
            <table class="table table-bordered align-middle">
               <thead>
                  <tr style="background: #f3e4c1;">
                     <th colspan="2" class="text-brown text-center">Course Details</th>
                  </tr>
               </thead>
               <tbody>
                  <tr>
                     <th>Course Title</th>
                     <td><?= htmlspecialchars($feedback->course['sub_title']); ?></td>
                  </tr>
                  <tr>
                     <th>Code</th>
                     <td><?= htmlspecialchars($feedback->course['sub_code']); ?></td>
                  </tr>
                  <tr>
                     <th>Teacher(s)</th>
                     <td><?= htmlspecialchars($feedback->course['faculty_names']); ?></td>
                  </tr>
               </tbody>
            </table>
         </div>

         <form method="post" class="mt-4">
            <label class="text-danger fw-bold">
               Please tell us how you would respond to the following questions.  
               Confine your response to within 1000 characters.
            </label>

            <?php foreach ($feedback->questions as $idx => $q): ?>
               <div class="form-group mt-3">
                  <label class="fw-bold"><?= htmlspecialchars($q['item_name']); ?></label>
                  <textarea name="question_<?= $idx + 1; ?>" 
                            class="form-control" 
                            maxlength="1000" 
                            required></textarea>
               </div>
            <?php endforeach; ?>

            <div class="form-group mt-3">
                <label class="fw-bold">Comments (optional)</label>
                <textarea name="comments" class="form-control" maxlength="1000"></textarea>
            </div>

            <div class="text-center">
               <button type="submit" class="btn btn-danger mt-4">Submit Feedback</button>
            </div>
         </form>
         <?php else: ?>
            <div class="alert alert-danger text-center mt-3">
               No course found for this selection.
            </div>
         <?php endif; ?>
      </div>
   </section>
</div>
<!-- dashboad-content-box-area-end -->

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'mid_sem_feedback_form';
include("./student-masters.php");
?>
