<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/common.php';
include_once __DIR__ . '/../classes/validation.php';
include_once __DIR__ . '/../classes/class_db.php';
include_once __DIR__ . '/../classes/class_student.php';
$validate = new validation();
$feedbackObj = new class_feedback();
$stu_roll = $validate->ValidateString($_SESSION['user_roll']);
$msg = '';
if (isset($_SESSION['flash_msg'])) {
    $msg = $_SESSION['flash_msg'];
    unset($_SESSION['flash_msg']); 
}
$courses = $feedbackObj->GetStudentCourses($stu_roll, null);
ob_start();
?>
<div class="tp-dashboard-course-list">
<section class="tpd-main pb-75">
  <div class="container">
    <!-- Show Alert Message -->
    <?php if (!empty($msg)) : ?>
      <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= htmlspecialchars($msg); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
      </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-lg-12">
                                 <div class="tp-dashboard-section">
                                    <h2 class="tp-dashboard-title">Feedback</h2><hr>
                                 </div>
                              </div>
      <div class="col-lg-12">
        <div class="tpd-content-layout">

          <!-- Floating button Academic Status -->
          <div class="tp-header-2-cart d-xxl-block">
            <a href="#book" class="side-button cartmini-open-btn"
               style="position: fixed; top: 50%; right: 0; transform: translateY(-50%);
                      background-color: #28a745; color: white; padding: 10px 10px;
                      text-decoration: none; font-size: 16px; font-weight: bold;
                      border-radius: 5px; writing-mode: vertical-rl; text-orientation: mixed;
                      box-shadow: 0 4px 6px rgba(0,0,0,0.3); transition: background 0.3s ease;
                      margin-right: 11px;"> Academic Status </a>
          </div>

          <!-- Table -->
          <div class="table" style="margin-top: 20px;">
            <table class="table table-bordered align-middle">
              <thead class="table-light" style="background: #f3e4c1;">
                <tr>
                  <th>#</th>
                  <th>Code</th>
                  <th>Course Title</th>
                  <th>Credits</th>
                  <th class="text-center">Actions</th>
                </tr>
              </thead>
              <tbody>
                <?php if (!empty($courses)) : 
                  $i = 1;
                  foreach ($courses as $row) :
                    $sub_code  = $validate->ValidateString($row['sub_code']);
                    $sub_title = $validate->ValidateString($row['sub_title']);
                    $sub_crdit = $validate->ValidateString($row['sub_crdit']);
                    $unique_code = $validate->ValidateString($row['unique_code'] ?? '');
                ?>
                    <tr>
                      <td><?= $i++; ?></td>
                      <td><?= htmlspecialchars($sub_code); ?></td>
                      <td><?= htmlspecialchars($sub_title); ?></td>
                      <td><?= htmlspecialchars($sub_crdit); ?></td>
                      <td class="text-center">
                        <?php if (!empty($unique_code)) : ?>
                          <a href="mid-sem-feedback-select.php?code=<?= urlencode($unique_code); ?>"
                             class="btn btn-sm me-2" style="background-color: #28a745; color: #fff;">
                             Select
                          </a>
                        <?php endif; ?>
                        <a href="feedback-abstain.php?code=<?= urlencode($unique_code); ?>"
                           class="btn btn-sm"
                           style="background:#a9181b; color:#fff;"
                           onclick="return confirm('Are you sure you want to abstain from giving feedback for this course?');">
                           Abstain
                        </a>
                      </td>
                    </tr>
                  <?php endforeach; ?>
                <?php else: ?>
                  <tr>
                    <td colspan="5" class="text-center text-danger">No courses found for this semester.</td>
                  </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>
<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'student_feedback';
include("./student-masters.php");
?>
