<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/class_student.php';
$stu_roll = $_SESSION['user_roll'] ?? '';
$checkoutObj = new class_student();
$success_msg = '';
$error_msg   = '';
if (isset($_POST['Submit'])) {
    $hostel        = trim($_POST['hostel']);
    $room          = trim($_POST['room']);
    $seat          = trim($_POST['seat']);
    $checkout_date = trim($_POST['checkout_date']);
    $checkout_type = trim($_POST['checkout_type']);
    $reason        = substr(preg_replace('/[^a-zA-Z0-9\s]/', '*', trim($_POST['reason'])), 0, 100);
    $return_date   = ($checkout_type === 'T') ? ($_POST['return_date'] ?? null) : null;

    if (!$hostel || !$room || !$seat || !$checkout_date || !$checkout_type || !$reason) {
        $error_msg = " Please fill all required fields.";
    } else {
        $inserted = $checkoutObj->insertCheckoutRequest(
            $stu_roll, $hostel, $room, $seat,
            $checkout_date, $checkout_type, $reason, $return_date
        );
        if ($inserted) {
            $success_msg = " Checkout request submitted successfully!";
        } else {
            $error_msg = " Failed to submit checkout request!";
        }
    }
}
$currentRoom = $checkoutObj->getCurrentRoom($stu_roll);
$requests    = $checkoutObj->getCheckoutRequests($stu_roll);
ob_start();
?>
<div class="tp-dashboard-course-list">
    <section class="tp-fact-wrapper">
        <h2 class="tp-dashboard-title">Hostel Check Out Information</h2>

        <?php if ($success_msg): ?>
            <div class="alert alert-success"><?= htmlspecialchars($success_msg) ?></div>
        <?php elseif ($error_msg): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error_msg) ?></div>
        <?php endif; ?>

        <?php if ($currentRoom): ?>
            <form method="post" class="form-horizontal">
                <div class="row">
                    <div class="col-lg-6">
                        <label>Hostel</label>
                        <input type="text" class="form-control" name="hostel"
                               value="<?= htmlspecialchars($currentRoom['hostel']) ?>" readonly>
                    </div>
                    <div class="col-lg-6">
                        <label>Current Room</label>
                        <input type="text" class="form-control" name="room"
                               value="<?= htmlspecialchars($currentRoom['room']) ?>" readonly>
                        <input type="hidden" name="seat" value="<?= htmlspecialchars($currentRoom['seat']) ?>">
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-lg-6">
                        <label>Date and Time of Check Out</label>
                        <input type="datetime-local" class="form-control" name="checkout_date" required>
                    </div>
                    <div class="col-lg-6">
                        <label>Reason (within 10 words)</label>
                        <input type="text" class="form-control" name="reason"
                               maxlength="100" placeholder="E.g. Family Emergency" required>
                    </div>
                </div>

             

                <div class="row mt-3" id="return_date_row">
                    <div class="col-lg-6">
                        <label>If temporary, specify Date of Return</label>
                        <input type="date" class="form-control" name="return_date">
                    </div>
                    <div class="col-lg-6">
                        <label>Specify Type</label>
                        <label><input type="radio" name="checkout_type" value="T" checked
                                      onclick="toggleReturnDate(true)"> Temporary</label>
                        <label class=""><input type="radio" name="checkout_type" value="P"
                                      onclick="toggleReturnDate(false)"> Permanent</label>
                    </div>
                </div>

                <div class="btn-group mt-3">
                    <button type="submit" class="btn btn-danger" name="Submit">Confirm and Submit</button>
                </div>
            </form>
        <?php endif; ?>

        <?php if (!empty($requests)): ?>
        <h2 class="tp-dashboard-title" style="    margin-top: 20px;">Your Check Out Requests</h2>
        <hr>
    
            <table class="" style="    height: 163px;">
                <tr>
                    <th>#</th>
                    <th>Checkout Date</th>
                    <th>Type</th>
                    <th>Reason</th>
                    <th>Return Date</th>
                    <th>Date Requested</th>
                    <th>Status</th>
                </tr>
                <?php $i = 1; foreach ($requests as $req): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($req['checkout_date']) ?></td>
                        <td><?= $req['checkout_type'] === 'T' ? 'Temporary' : 'Permanent' ?></td>
                        <td><?= htmlspecialchars($req['checkout_reason']) ?></td>
                        <td><?= $req['return_date'] ? htmlspecialchars($req['return_date']) : '-' ?></td>
                        <td><?= htmlspecialchars($req['date_req']) ?></td>
                        <td>
                            <?php
                                if ($req['req_status'] === 'A') echo " Approved";
                                elseif ($req['req_status'] === 'R') echo " Rejected";
                                else echo " Pending";
                            ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </table>
        <?php endif; ?>
    </section>
</div>

<script>
function toggleReturnDate(show) {
    document.getElementById("return_date_row").style.display = show ? "flex" : "none";
}
window.onload = function() {
    toggleReturnDate(true); // default = Temporary
};
</script>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
$PAGENAME = 'hostel_checkout_information';
include("./student-masters.php");
?>
