<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/class_student.php';
$stu_roll    = $_SESSION['user_roll'] ?? '';
$unique_code = $_GET['code'] ?? '';
try {
   $feedback = new class_midsem_feedback($stu_roll, $unique_code);
   $feedback->validateCode();
   $feedback->fetchCourse();
   $feedback->handleSubmit();
} catch (Exception $e) {
   die("<div style='color:red;font-weight:bold;'>" . $e->getMessage() . "</div>");
}
ob_start();
?>


<div class="tp-dashboard-course-list">
   <section class="tp-fact-wrapper">
      <div class="row">
         <div class="col-lg-12">
            <div class="tp-dashboard-section">
               <h2 class="tp-dashboard-title text-center">Mid Semester Feedback</h2>
            </div>
         </div>
      </div>

      <!-- Success Message -->
      <?php if (!empty($feedback->msg)) : ?>
         <div class="alert alert-success text-center">
            <?= htmlspecialchars($feedback->msg); ?>
         </div>
      <?php endif; ?>

      <div class="container mt-4">
         <!-- Course Info -->
         <table class="table table-bordered" style="    height: 127px;">
            <tr>
               <th>Course Title</th>
               <td><?= htmlspecialchars($feedback->course['sub_title']); ?></td>
            </tr>
            <tr>
               <th>Course Code</th>
               <td><?= htmlspecialchars($feedback->course['sub_code']); ?></td>
            </tr>
            <tr>
               <th>Instructor</th>
               <td><?= htmlspecialchars($feedback->course['faculty_names']); ?></td>
            </tr>
         </table>

         <form method="post" autocomplete="off">
            <!-- Overall Score -->
            <div class="mb-3">
    <label class="fw-bold mb-2">Select Score:</label>
    <div style="display:flex; gap:10px; font-size:14px;">
        <label><input type="radio" name="overall_score" value="0.0" required style="margin-right: 8px;">0.0</label>
        <label><input type="radio" name="overall_score" value="0.5" style="margin-right: 8px;">0.5</label>
        <label><input type="radio" name="overall_score" value="1.0" style="margin-right: 8px;">1.0</label>
        <label><input type="radio" name="overall_score" value="1.5" style="margin-right: 8px;">1.5</label>
        <label><input type="radio" name="overall_score" value="2.0" style="margin-right: 8px;">2.0</label>
        <label><input type="radio" name="overall_score" value="2.5" style="margin-right: 8px;">2.5</label>
        <label><input type="radio" name="overall_score" value="3.0" style="margin-right: 8px;">3.0</label>
        <label><input type="radio" name="overall_score" value="3.5" style="margin-right: 8px;">3.5</label>
        <label><input type="radio" name="overall_score" value="4.0" style="margin-right: 8px;">4.0</label>
        <label><input type="radio" name="overall_score" value="4.5" style="margin-right: 8px;">4.5</label>
        <label><input type="radio" name="overall_score" value="5.0" style="margin-right: 8px;">5.0</label>
    </div>
</div>



            <!-- Comment Box -->
            <div class="form-group mb-3">
               <label class="fw-bold" for="comments">Comments</label>
               <p class="mb-1 text-danger" style="font-size:12px;">
                  You may give comments about the course and teaching.
                  <i>(maximum 500 characters)</i>
               </p>
               <textarea id="comments" name="comments" class="form-control" maxlength="500" rows="4" placeholder="Type your comments here..." required></textarea>
            </div>

            <!-- Submit Button -->
            <div class="text-center">
               <button type="submit" class="btn btn-danger">Submit Feedback</button>
            </div>
         </form>

      </div>
   </section>
</div>

<?php
$mainpagecontent = ob_get_clean();
$PAGENAME = 'mid_sem_feedback_form';
include("./student-masters.php");
?>