<?php
include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/class_student.php';

$stu_roll = $_SESSION['user_roll'] ?? '';
$stu_name = $_SESSION['user_name'] ?? '';
if (!$stu_roll) {
    die("Student roll not found. Please login again.");
}
$studentObj = new class_student();
$success_msg = '';
$error_msg   = '';
if (isset($_POST['Submit'])) {
    $new_room = trim($_POST['new_room'] ?? '');
    $reason   = trim($_POST['reason'] ?? '');
    $reason   = str_replace(["'", '"', ";", "<", ">"], "*", $reason);
    if (!$new_room || !$reason) {
        $error_msg = "Please fill all fields.";
    } else {
        $currentRoom = $studentObj->getCurrentRoom($stu_roll);
        if (!empty($currentRoom)) {
            $inserted = $studentObj->insertRoomChangeRequest(
                $stu_roll,
                $currentRoom['hostel'],
                $currentRoom['room'],
                $new_room,
                $reason
            );
            if ($inserted) {
                $success_msg = "Room change request submitted successfully!";
            } else {
                $error_msg = "Failed to submit request!";
            }
        } else {
            $error_msg = "No current room found!";
        }
    }
}
$currentRoom = $studentObj->getCurrentRoom($stu_roll);
$roomMate = null;
if (!empty($currentRoom)) {
    $roomMateRoll = $studentObj->getRoomMate($currentRoom['hostel'], $currentRoom['room'], $currentRoom['seat']);
    if ($roomMateRoll) {
        $roomMate = $studentObj->getStudentName($roomMateRoll);
    }
}

// Vacant rooms (only if hostel known)
$vacantRooms = !empty($currentRoom) ? $studentObj->getVacantRooms($currentRoom['hostel']) : [];

// Past requests
$requests = $studentObj->getRoomChangeRequests($stu_roll);

ob_start();
?>

<div class="tp-dashboard-course-list">
    <section class="tp-fact-wrapper">
        <div class="row">
            <div class="col-lg-12">
                <div class="tp-dashboard-section">
                    <h2 class="tp-dashboard-title">Room Change Request</h2>
                </div>
            </div>
        </div>

        <!-- SUCCESS / ERROR MSG -->
        <?php if ($success_msg): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success_msg); ?></div>
        <?php elseif ($error_msg): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error_msg); ?></div>
        <?php endif; ?>

        <!-- CURRENT ROOM INFO -->
        <?php if (!empty($currentRoom)): ?>
            <table class="table table-condensed table-bordered" style="    height: 100px;">
                <tr><td>Hostel</td><td><?php echo htmlspecialchars($currentRoom['hostel']); ?></td></tr>
                <tr><td>Current Room</td><td><?php echo htmlspecialchars($currentRoom['room']); ?></td></tr>
                <tr><td>Room-mate</td><td><?php echo htmlspecialchars($roomMate ?? 'N/A'); ?></td></tr>
            </table>

            <!-- REQUEST FORM -->
        
            <form method="post" action="" class="form-horizontal">
                <table class=" table-condensed table-bordered" style="margin-bottom: 15px;">
                    <tr>
                        <td>Select New Room</td>
                        <td>
                            <select name="new_room" class="form-control scrollable-select" size="10" required>
                                <option value="" selected>-- Select Room --</option>
                                <?php foreach ($vacantRooms as $room): ?>
                                    <option value="<?php echo htmlspecialchars($room['room']); ?>">
                                        <?php echo htmlspecialchars($room['room']); ?> (<?php echo (int)$room['ccc']; ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            Room number (Vacancy)
                        </td>
                    </tr>
                    <tr>
                        <td>Reason</td>
                        <td>
                            <input type="text" name="reason" size="60" maxlength="250" required>
                            <br><span style="color:blue;">(within 10 words)</span>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="center">
                            <input type="submit" class="btn btn-primary" name="Submit" style="background: #cb4f4e;" value="Confirm and Submit">
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2" align="center">
                            <span style="color:red;">Alert: Please check that your room-mate has also requested for a change to the same room.</span>
                        </td>
                    </tr>
                </table>
            </form>
        <?php endif; ?>

        <!-- PAST REQUESTS -->
        <?php if (!empty($requests)): ?>
            <h2 class="mt-4">Room Change Request Status</h2>
        <hr>
            <table class="table table-condensed table-bordered">
                <tr>
                    <th>#</th>
                    <th>Room Requested</th>
                    <th>Date</th>
                    <th>Status</th>
                </tr>
                <?php $i = 1; foreach ($requests as $req): ?>
                    <tr>
                        <td><?php echo $i++; ?></td>
                        <td><?php echo htmlspecialchars($req['room_req']); ?></td>
                        <td><?php echo htmlspecialchars(date("d M Y", strtotime($req['date_req']))); ?></td>
                        <td><?php echo htmlspecialchars($req['req_status']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </table>
            <p><b>R</b>: Requested | <b>A</b>: Approved | <b>N</b>: Not approved</p>
        <?php endif; ?>
    </section>
</div>

<?php
$mainpagecontent = ob_get_contents();
ob_end_clean();

$PAGENAME = 'room_change_request';
include("./student-masters.php");
?>
