<?php

include_once __DIR__ . '/../session/bsms-session.php';
include_once __DIR__ . '/../classes/common.php';
include_once __DIR__ . '/../classes/validation.php';
include_once __DIR__ . '/../classes/class_db.php';
include_once __DIR__ . '/../classes/class_root.php';
include_once __DIR__ . '/../classes/class_student.php';
$rootObj    = new class_root();
$studentObj = new class_student();
$stu_roll   = $_SESSION['user_roll'] ?? '';
if (empty($stu_roll)) {
    die("Student roll not found. Please login again.");
}
$student_data  = $rootObj->GetStudentData($stu_roll);
$student_name  = $student_data['stu_name'] ?? ($student_data['name'] ?? 'Unknown');
$stu_roll      = $student_data['stu_roll'] ?? $stu_roll;
$current_sem = $studentObj->GetCurrentSemester($stu_roll);
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = trim($_POST['action'] ?? '');
    $message = '';

    if ($action === 'add' && !empty($_POST['add_code'])) {
        $added = $studentObj->AddCourse($stu_roll, trim($_POST['add_code']), $current_sem);
        $message = $added ? "Course added successfully." : "Course could not be added or already registered.";
    }

    if ($action === 'drop' && !empty($_POST['drop_code'])) {
        $dropped = $studentObj->MoveToDroppedCourses($stu_roll, trim($_POST['drop_code']));
        $message = $dropped ? "Course dropped successfully." : "Course could not be dropped.";
    }

    if (!empty($message)) {
        $_SESSION['message'] = $message;
    }

    header("Location: " . $_SERVER['REQUEST_URI']);
    exit;
}
$active_courses    = $studentObj->GetStudentCourses($stu_roll, $current_sem, "active") ?? [];
$dropped_courses   = $studentObj->GetStudentCourses($stu_roll, $current_sem, "dropped") ?? [];
$available_courses = $studentObj->GetAvailableCourses($stu_roll, $current_sem) ?? [];
$total_credits = array_sum(array_map(fn($c) => intval($c['sub_crdit'] ?? 0), $active_courses));
ob_start();
?>

<div class="tp-dashboard-course-list">
    <section class="tp-fact-wrapper">
        <div class="tp-dashboard-section">
            <h2 class="tp-dashboard-title">Course Registration</h2>
        </div>

        <!-- Student Info -->
        <div class="form-container">
            <?php if (!empty($_SESSION['message'])): ?>
                <div class="alert alert-info"><?= htmlspecialchars($_SESSION['message']); unset($_SESSION['message']); ?></div>
            <?php endif; ?>

            <div class="row mb-3">
                <div class="col-lg-6">
                    <label>Name</label>
                    <input type="text" value="<?= htmlspecialchars($student_name, ENT_QUOTES) ?>" readonly class="form-control">
                </div>
                <div class="col-lg-6">
                    <label>Roll No</label>
                    <input type="text" value="<?= htmlspecialchars($stu_roll, ENT_QUOTES) ?>" readonly class="form-control">
                </div>
            </div>

            <div class="row mt-2">
                <div class="col-lg-12">
                    <div class="header-bar" style="background-color: #F4F5FA; color: #28a745; font-weight: bold; padding: 10px; font-size: 18px;">
                        <?= ($total_credits >= 18 ? "Registration Done" : "Registration Pending") ?>
                        <span style="float: right;">Semester <?= htmlspecialchars($current_sem, ENT_QUOTES) ?></span>
                    </div>
                </div>
            </div>

            <!-- Active Courses Table -->
            <table class="course-table mt-3 table table-striped" style="width:100%; border-collapse:collapse;">
                <thead>
                    <tr style="background:#f8f8f8;">
                        <th>Course Code</th>
                        <th>Course Title</th>
                        <th>Credits</th>
                        <th>Drop</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($active_courses)): ?>
                        <?php foreach ($active_courses as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['sub_code'] ?? '', ENT_QUOTES) ?></td>
                                <td><?= htmlspecialchars($row['sub_title'] ?? '', ENT_QUOTES) ?></td>
                                <td><?= htmlspecialchars($row['sub_crdit'] ?? '0', ENT_QUOTES) ?></td>
                                <td>
                                    <form method="post" action="" style="display:inline;">
                                        <input type="hidden" name="action" value="drop">
                                        <input type="hidden" name="drop_code" value="<?= htmlspecialchars($row['unique_code'] ?? $row['sub_code'], ENT_QUOTES) ?>">
                                        <button type="submit" onclick="return confirm('Drop <?= addslashes(htmlspecialchars($row['sub_code'] ?? '', ENT_QUOTES)) ?>?');" class="btn btn-danger btn-sm">Drop</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <tr style="font-weight:bold;">
                            <td colspan="2" align="right">Total Credits</td>
                            <td><?= $total_credits ?></td>
                            <td></td>
                        </tr>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" align="center" style="color:red;">No active courses</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

            <!-- Add Course -->
            <?php if (!empty($available_courses)): ?>
                <form method="post" action="" style="margin-top:20px; border:1px solid #cde6ff; padding:10px; background:#f9fcff; border-radius:5px;">
                    <label>Add Course</label>
                    <div style="display:flex; gap:10px; align-items:center;">
                        <select name="add_code" required size="10" style="width:100%; max-height:200px; overflow-y:auto;">
                            <option value="" selected>-- Select a course --</option>
                            <?php foreach ($available_courses as $row): ?>
                                <option value="<?= htmlspecialchars($row['unique_code'], ENT_QUOTES) ?>">
                                    <?= htmlspecialchars($row['sub_code'] . " - " . $row['sub_title'] . " (" . $row['sub_crdit'] . " cr, Slot: " . $row['slot'] . ")", ENT_QUOTES) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <input type="hidden" name="action" value="add">
                        <button type="submit" class="btn btn-primary">Add Course</button>
                    </div>
                </form>
            <?php endif; ?>

            <!-- Dropped Courses Table -->
            <?php if (!empty($dropped_courses)): ?>
                <div class="drop-box" style="margin-top:20px;">
                    <h4 style="color:#800000;">Dropped Courses</h4>
                    <table class="course-table table table-bordered" style="width:100%; border-collapse:collapse;">
                        <thead>
                            <tr style="background:#f8f8f8;">
                                <th>Course Code</th>
                                <th>Course Title</th>
                                <th>Credits</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($dropped_courses as $row): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['sub_code'] ?? '', ENT_QUOTES) ?></td>
                                    <td><?= htmlspecialchars($row['sub_title'] ?? '', ENT_QUOTES) ?></td>
                                    <td><?= htmlspecialchars($row['sub_crdit'] ?? '0', ENT_QUOTES) ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>

        </div>
    </section>
</div>

<?php
$mainpagecontent = ob_get_clean();
$PAGENAME = 'student_registration';
include("./student-masters.php");
?>
