<?php

include_once 'class_db_org.php';
include_once 'class_log.php';
include_once 'common.php';

class class_admin {
    /* Getting the master Setting Table */

    public function MasterSettingValues() {

        $log = new common();
        $ObjDB = new class_db();

        $query_str = "SELECT * FROM isr_master_setting_tbl WHERE 1";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    /* Getting the List Of Active Batch For Flag Setting */

    public function MasterActiveBatchFlagSetting() {

        $log = new common();
        $ObjDB = new class_db();

        $query_str = "SELECT * FROM isr_system_flags_tbl WHERE 1 AND flag_active in ('A', 'Y', 'Z') order by flag_active, flag_user";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    /* Update System Flag */

    public function UpdateSystemFlags() {
        $log = new common();
        $ObjDB = new class_db();

        $ref_id = $this->ref_pk_id;
        $col_name = $this->col_name;
        $activity_str = $this->activity_str;

        $UpdateQuery = "UPDATE isr_system_flags_tbl SET " . $col_name . "='" . $activity_str . "' WHERE flag_sr='$ref_id'";
        $ObjDB->sproc_name = $UpdateQuery;
        $result_str = $ObjDB->ExecuteQuery();

        $datetime = DATE('Y-m-d H:i:s');
        $admin_roll = $this->admin_roll;
        $activity = "Flags changed - $col_name:$activity_str for flag_sr $ref_id";

        $query_str = "INSERT INTO isr_actions_tbl (roll, activity, datetime) VALUES('" . $admin_roll . "','" . $activity . "','" . $datetime . "')";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->ExecuteQuery();

        return "SUCCESS";
    }

    /* Getting the List Of Active MS Projects */

    public function MasterActiveMSProjectFlagSetting() {

        $log = new common();
        $ObjDB = new class_db();

        $query_str = "SELECT * FROM isr_prj_flags_tbl WHERE 1 AND flag_active in ('Y') order by start_sem";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    /* Getting the Semester Name list */

    public function MasterSemesterList() {

        $log = new common();
        $ObjDB = new class_db();

        $query_str = "SELECT * FROM isr_sem_name_tbl WHERE 1";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    /* Update Project Flag */

    public function UpdateProjectFlags() {
        $log = new common();
        $ObjDB = new class_db();

        $ref_id = $this->ref_pk_id;
        $col_name = $this->col_name;
        $activity_str = $this->activity_str;

        $UpdateQuery = "UPDATE isr_prj_flags_tbl SET " . $col_name . "='" . $activity_str . "' WHERE flag_sr='$ref_id'";
        $ObjDB->sproc_name = $UpdateQuery;
        $result_str = $ObjDB->ExecuteQuery();

        /*
          $datetime = DATE('Y-m-d H:i:s');
          $admin_roll = $this->admin_roll;
          $activity = "Flags changed - $col_name:$activity_str for flag_sr $ref_id";

          $query_str  = "INSERT INTO isr_actions_tbl (roll, activity, datetime) VALUES('".$admin_roll."','".$activity."','".$datetime."')";
          $ObjDB->sproc_name = $query_str;
          $result_str = $ObjDB->ExecuteQuery();
         */
        return "SUCCESS";
    }

    /* Getting the list of courses which can be changed */

    public function GetTempCourseList() {

        $dy = "";
        $log = new common();
        $ObjDB = new class_db();

        $ccl = $this->ccl;
        if (!empty($ccl)) {
            $dy = " AND sub_list='$ccl'";
        }
        $search = $this->search_str;
        if (!empty($search)) {
            $dy .= "AND " . $search;
        }
        $order_str = $this->order_str;

        $query_str = "SELECT * FROM isr_curriculum_temp_tbl WHERE 1 $dy $order_str";

        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    /* Getting The Count of the course of current cuuriculam */

    public function GetTempCourseCount() {
        $dy = "";
        $log = new common();
        $ObjDB = new class_db();

        $ccl = $this->ccl;
        if (!empty($ccl)) {
            $dy = " AND sub_list='$ccl'";
        }
        $search = $this->search_str;
        if (!empty($search)) {
            $dy .= "AND " . $search;
        }
        $query_str = "SELECT count(sr) as crCount FROM isr_curriculum_temp_tbl WHERE 1 $dy";

        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        list($crCount) = mysqli_fetch_row($result_str);

        return $crCount;
    }

    /* Getting the list of Faculty from Temp Table */

    public function GetTempFacultyList() {

        $dy = "";
        $log = new common();
        $ObjDB = new class_db();

        $sub_code = $this->sub_code;
        if (!empty($sub_code)) {
            $dy = " AND a.bsms_code='$sub_code'";
        }

        $query_str = "SELECT a.fac_code, b.name, a.fac_order, a.sr FROM isr_faculty_temp_tbl a, isr_faculty_tbl b where 1 $dy AND a.fac_code = b.roll order by a.fac_order";

        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    /* Getting the Temp Course Curriculum from unique code */

    public function GetTempCourseDetails() {

        $dy = "";
        $log = new common();
        $ObjDB = new class_db();

        $unique_code = $this->unique_code;
        if (!empty($unique_code)) {
            $dy = " AND unique_code='$unique_code'";
        }

        $query_str = "SELECT * FROM isr_curriculum_temp_tbl WHERE 1 $dy";

        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    /* Updatig the Course Curriculam from unique code */

    public function UpdateTempCourse() {

        $dy = "";
        $log = new common();
        $ObjDB = new class_db();

        $unique_code = $this->unique_code;

        $query_str = "UPDATE isr_curriculum_temp_tbl SET title='$this->course_title', slot='$this->slot', sem='$this->sem_sel_str' WHERE unique_code='$unique_code'";
        $ObjDB->sproc_name = $query_str;
        $result_update = $ObjDB->ExecuteQuery();

        return "SUCCESS";
    }

    /* Getting the Faculty List */

    public function GetFacultyList() {
        $dy = "";
        $log = new common();
        $ObjDB = new class_db();

        if (!empty($this->fac_status)) {
            $dy = " AND fac_status = '" . $this->fac_status . "'";
        }


        if (!empty($this->fac_roll)) {
            $dy .= " AND roll = '" . $this->fac_roll . "'";
        }

        $query_str = "SELECT * FROM isr_faculty_tbl WHERE 1 $dy ORDER BY name";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    public function InsertAuxFaculty() {
        $dy = "";
        $log = new common();
        $ObjDB = new class_db();

        $sub_code = $this->sub_code;
        $fac_code = $this->fac_code;
        $admin_roll = $this->user_roll;
        if (!empty($fac_code)) {

            $datetime = DATE('Y-m-d H:i:s');

            $SELECT_FAC = "SELECT fac_order FROM isr_faculty_temp_tbl WHERE bsms_code = '$sub_code' order by fac_order DESC limit 1";
            $ObjDB->sproc_name = $SELECT_FAC;
            $result_str = $ObjDB->SelectQuery();
            list($fac_order) = mysqli_fetch_array($result_str);

            $new_order = $fac_order + 1;

            $qin = "INSERT into isr_faculty_temp_tbl (bsms_code, fac_code, fac_order) values ('$sub_code', '$fac_code', '$new_order')";
            $ObjDB->sproc_name = $qin;
            $ObjDB->ExecuteQuery();

            $activity = "Added aux for $sub_code";
            $query1 = "INSERT INTO actions (roll, activity, datetime) VALUES('" . $admin_roll . "','" . $activity . "','" . $datetime . "')";
            $ObjDB->sproc_name = $query1;
            $ObjDB->ExecuteQuery();
        }

        return $result_str;
    }

    public function UpdateFacultyOrder() {

        $dy = "";
        $log = new common();
        $ObjDB = new class_db();

        $facOrder = $this->facOrder;
        $srVal = $this->srVal;
        $SubCode = $this->SubCode;

        $query_select = "SELECT fac_order, sr FROM isr_faculty_temp_tbl WHERE  bsms_code ='$SubCode' AND fac_order < '$facOrder' ORDER BY fac_order DESC LIMIT 1";
        $ObjDB->sproc_name = $query_select;
        $result_str = $ObjDB->SelectQuery();
        list($display_order_less_one, $getsr) = mysqli_fetch_row($result_str);

        $query_update = "UPDATE isr_faculty_temp_tbl SET fac_order='$display_order_less_one' WHERE sr='$srVal'";
        $ObjDB->sproc_name = $query_update;
        $ObjDB->ExecuteQuery();

        $query_update_replace = "UPDATE isr_faculty_temp_tbl SET fac_order='$facOrder' WHERE sr='$getsr'";
        $ObjDB->sproc_name = $query_update_replace;
        $ObjDB->ExecuteQuery();
    }

    public function DeleteFacultyAllocation() {
        $dy = "";
        $log = new common();
        $ObjDB = new class_db();
        $srDel = $this->srDel;
        $sub_code = $this->subDel;

        $qdel = "DELETE FROM isr_faculty_temp_tbl WHERE sr = '$srDel' and bsms_code = '$sub_code'";
        $ObjDB->sproc_name = $qdel;
        $ObjDB->ExecuteQuery();
    }

    public function InsertHead() {
        $dy = "";
        $log = new common();
        $ObjDB = new class_db();

        $datetime = DATE('Y-m-d H:i:s');

        $cpos = $this->cpos;
        $cdis = $this->cdis;
        $crol = $this->crol;

        $admin_roll = $this->admin_roll;

        $query = "INSERT INTO isr_heads_tbl (fac_roll, dept, position) values ('$crol', '$cdis', '$cpos')";
        $ObjDB->sproc_name = $query;
        $ObjDB->ExecuteQuery();

        $activity = "Chair allocated: " . $cpos . " - " . $cdis . " - " . $crol;

        $query_sql = "INSERT INTO isr_actions_tbl (roll, activity, datetime) VALUES('" . $admin_roll . "','" . $activity . "','" . $datetime . "')";
        $ObjDB->sproc_name = $query_sql;
        $ObjDB->ExecuteQuery();
    }

    public function DeleteHead() {
        $dy = "";
        $log = new common();

        $datetime = DATE('Y-m-d H:i:s');

        $ObjDB = new class_db();

        $id_to_remove = $this->Delheadid;
        $roll = $this->Delfacroll;
        $admin_roll = $this->admin_roll;

        $queryDel = "delete from isr_heads_tbl where head_id = '$id_to_remove' and fac_roll = '$roll'";
        $ObjDB->sproc_name = $queryDel;
        $ObjDB->ExecuteQuery();

        $activity = "Chair removed: " . $roll;
        $queryIns = "INSERT INTO isr_actions_tbl (roll, activity, datetime) VALUES('" . $admin_roll . "','" . $activity . "','" . $datetime . "')";
        $ObjDB->sproc_name = $queryIns;
        $ObjDB->ExecuteQuery();
    }

    public function GetFacultyChair() {

        $log = new common();
        $ObjDB = new class_db();

        $query_str = "SELECT a.*, b.name from isr_heads_tbl a, isr_faculty_tbl b where a.dept in ('BIO', 'CHM', 'ECS', 'MTH', 'IDC', 'PHY', 'HSS', 'DS', 'SE') and a.fac_roll = b.roll order by a.position, a.dept";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    public function GetRegistrationCourseList() {
        $log = new common();
        $ObjDB = new class_db();

        $res_sem = $this->res_sem;

        $query_str = "SELECT distinct a.sub_code, a.sub_list, b.sub_title FROM isr_sub_available_tbl a, isr_curriculum_tbl b where a.sub_list = b.sub_list and  a.sub_code = b.sub_code and b1_sem = '$res_sem' order by a.sub_list desc, a.sub_code";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    public function GetRegistrationCourseStudentList() {
        $log = new common();
        $ObjDB = new class_db();

        $course_code = $this->course_code;
        $res_sem = $this->res_sem;

        $student_list_arr[] = array();

        $query_str = "select flag_user, batch_name from isr_system_flags_tbl where flag_active in ('Y', 'Z') order by flag_user";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        $c = 0;
        while ($rowb = mysqli_fetch_array($result_str)) {
            $batch = $rowb['flag_user'];
            $batch_name = $rowb['batch_name'];
            $reg_file = 'isr_reg_' . $batch . "_tbl";

            $query_str1 = "select a.stu_roll, a.grade, b.name from $reg_file a, isr_stu_main_tbl b where a.b1_sem = '$res_sem' and a.stu_roll = b.roll and  a.sub_code = '$course_code' and a.sub_flag = 'Y' order by stu_roll";
            $ObjDB->sproc_name = $query_str1;
            $result_str1 = $ObjDB->SelectQuery();

            while ($rowb1 = mysqli_fetch_array($result_str1)) {
                $stu_roll = $rowb1['stu_roll'];
                $stu_name = $rowb1['name'];
                $grade = $rowb1['grade'];

                $student_list_arr[$c]['batch_name'] = $batch_name;
                $student_list_arr[$c]['stu_roll'] = $stu_roll;
                $student_list_arr[$c]['stu_name'] = $stu_name;
                $student_list_arr[$c]['grade'] = $grade;

                $c = $c + 1;
            }
        }

        $query_str_2 = "select a.*, b.student_name, b.student_email from isr_gsam_course_student_tbl a, isr_gsam_student_tbl b where a.stu_roll = b.student_roll and a.sub_code = '$course_code' and a.b1_sem = '$res_sem'";
        $ObjDB->sproc_name = $query_str_2;
        $result_str2 = $ObjDB->SelectQuery();

        while ($rowb2 = mysqli_fetch_array($result_str2)) {
            $stu_roll = $rowb2['stu_roll'];
            $stu_name = $rowb2['student_name'];
            $grade = $rowb2['course_grade'];

            $student_list_arr[$c]['batch_name'] = "PhD";
            $student_list_arr[$c]['stu_roll'] = $stu_roll;
            $student_list_arr[$c]['stu_name'] = $stu_name;
            $student_list_arr[$c]['grade'] = $grade;

            $c = $c + 1;
        }

        return $student_list_arr;
    }

    public function GetStudentDetailsbyRollNumber() {

        $log = new common();
        $ObjDB = new class_db();
        $roll_number = $this->roll_number;
        $sr = $this->sr;
        $dy = "";
        if (!empty($sr)) {
            $dy = " AND sr='$sr'";
        }

        $query_str = "SELECT * FROM isr_stu_main_tbl where roll = '$roll_number' $dy";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    public function GetStudentDetailsbyBatch() {

        $log = new common();
        $ObjDB = new class_db();
        $batch_num = $this->batch;

        $query_str = "SELECT * FROM isr_stu_main_tbl where batch = '$batch_num' order by roll";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    public function GetSemList() {

        $log = new common();
        $ObjDB = new class_db();
        $sem_num = $this->sem_num;
        $dy = "";
        if (!empty($sem_num)) {
            $dy = " AND sem_num = '$sem_num'";
        }

        $query_str = "SELECT * FROM isr_iiser_sem_tbl where 1 $dy";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    public function GetStudentDetailsbyOtherValue() {

        $log = new common();
        $ObjDB = new class_db();
        $stu_details = $this->stu_details;

        $query_str = "SELECT * FROM isr_stu_main_tbl where name like '%$stu_details%' order by roll";
        $ObjDB->sproc_name = $query_str;
        $result_str = $ObjDB->SelectQuery();

        return $result_str;
    }

    public function AddTempCourse() {

        $dy = "";
        $log = new common();
        $ObjDB = new class_db();

        $course_code = $this->course_code;
        $phd_code = $this->phd_code;
        /* Check Course code duplicate */
        $query_str = "SELECT sr FROM isr_curriculum_temp_tbl WHERE bsms_code='$course_code'";
        $ObjDB->sproc_name = $query_str;
        $result_query = $ObjDB->SelectQuery();
        $error_flag = 1;
        if (mysqli_num_rows($result_query) > 0) {
            $error_flag = 2;
            $msg = "BSMS Code is already inserted!";
        } else {
            /* Check PHD Code Duplicate */
            $query_str = "SELECT sr FROM isr_curriculum_temp_tbl WHERE phd_code='$phd_code'";
            $ObjDB->sproc_name = $query_str;
            $result_query_1 = $ObjDB->SelectQuery();
            if (mysqli_num_rows($result_query_1) > 0) {
                $error_flag = 2;
                $msg = "PHD Code is already inserted!";
            }
        }

        if ($error_flag == "1") {

            $unique_code = $log->UniqueStringOflength("32");

            $query_str = "INSERT INTO isr_curriculum_temp_tbl (phd_code, bsms_code, title, slot, sem, unique_code, bsms_credit, phd_credit) VALUES ('$this->phd_code', '$this->course_code', '$this->course_title', '$this->slot', '$this->sem_sel_str', '$unique_code', '$this->course_credit', '$this->phd_credit');";
            $ObjDB->sproc_name = $query_str;
            $result_insert = $ObjDB->ExecuteQuery();
            $msg = "SUCESS";
        }

        return $msg;
    }
}
