<?php
include_once __DIR__ . '/settings.php';

class class_db {
    public $sproc_name;          // SQL query or procedure
    private $numrows = 0;        // Last query affected rows or selected rows
    private $generated_id = 0;   // Last inserted ID
    private $user_type = "";     // Store user type

    // Connect to DB
    private function MyConnectDB() {
        $OBJCONNECT = new class_settings();
        return $OBJCONNECT->MyConnectDB();
    }

    // Close DB connection
    private function MyDisConnectDB($conn) {
        if ($conn) mysqli_close($conn);
    }

    // Execute SELECT query
    public function SelectQuery($singleRow = false) {
        $conn = $this->MyConnectDB();
        if (empty($this->sproc_name) || !$conn) return [];

        $result = mysqli_query($conn, $this->sproc_name);
        if (!$result) {
            $this->MyDisConnectDB($conn);
            return [];
        }

        $data = [];
        $this->numrows = mysqli_num_rows($result);

        if ($singleRow) {
            $row = mysqli_fetch_assoc($result) ?: [];
            $data = $row;
            if (isset($row['user_type'])) $this->user_type = $row['user_type'];
        } else {
            while ($row = mysqli_fetch_assoc($result)) {
                $data[] = $row;
                if (isset($row['user_type'])) $this->user_type = $row['user_type'];
            }
        }

        mysqli_free_result($result);
        $this->MyDisConnectDB($conn);
        return $data;
    }

    // Execute INSERT, UPDATE, DELETE query
    public function ExecuteQuery() {
        $conn = $this->MyConnectDB();
        if (empty($this->sproc_name) || !$conn) return 0;

        $result = mysqli_query($conn, $this->sproc_name);
        $this->generated_id = mysqli_insert_id($conn);
        $this->numrows = mysqli_affected_rows($conn);

        $this->MyDisConnectDB($conn);
        return $this->numrows;
    }

    // Escape user input for safe queries
    public function EscapeString($input) {
        $conn = $this->MyConnectDB();
        if (!$conn) return $input;

        $escaped = mysqli_real_escape_string($conn, $input);
        $this->MyDisConnectDB($conn);
        return $escaped;
    }

    // Get number of rows from last query
    public function getNumRows() {
        return $this->numrows;
    }

    // Get last generated ID from INSERT query
    public function getGeneratedId() {
        return $this->generated_id;
    }

    // Get stored user type
    public function getUserType() {
        return $this->user_type;
    }
public function InsertQuery() {
    return $this->ExecuteQuery();
}

   
}
?>
