<?php
ob_start();
$page_name_info = "manage_lead";
include_once '../session/salesexe-session.php';
include_once '../classes/settings.php';
include_once '../classes/common.php';
include_once '../classes/class_admin.php';
include_once '../classes/validation.php';

$Object_setting = new class_settings();
$serversiteurl = $Object_setting->siteurl;
$objadmin = new class_admin();

$added_by = $_SESSION['staff_sessionid'];
$added_by = $objadmin->added_by = $added_by;

$result_salesexecutive = $objadmin->GetSalesExecutive();
?>
<div class="content-wrapper">
    <div class="page-header">
        <h3 class="page-title"> Lead Listing </h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="">Lead</a></li>
                <li class="breadcrumb-item active" aria-current="page">Lead Listing</li>
            </ol>
        </nav>
    </div>
    <div class="row">
        <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <form class="row" name="frmFilter" id="frmFilter" method="POST">
                        <div class="col-9"></div>
                        <div class="col-3">
                            <select name="filter_status" onchange="return FilterApplicantList();" id="filter_status" class="form-control">
                                <option value="">All Status</option>
                                <option value="10">New Lead</option>
                                <option value="11">Follow-up</option>
                                <option value="12">Not Interested</option>
                                <option value="13">Meeting Schedule & Transfer to Sales Executive</option>
                                <option value="15">Site Survey</option>
                                <option value="16">Solar Design</option>
                                <option value="17">Preparing Proposal</option>
                                <option value="18">Receive Work Order</option>
                                <option value="19">Installer & Incharge Assign</option>
                                <option value="20">Delivering Material</option>
                                <option value="21">Installation</option>
                                <option value="22">Site Inspection</option>
                                <option value="23">Net Metering</option>
                                <option value="24">Handing Over Certificate</option>
                                <option value="25">Compiling and filing all the papers</option>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-sm-12 text-center">
                            <div id="divProcessingF" class="alert alert-info" style="display: none;">Processing... Please wait.</div>
                        </div>
                        <!--</div>-->
                    </form>
                    <div class="table-responsive">
                        <table id="tbladminList" class="table table-striped dataTable table-hover table-bordered table-condensed" style="font-size: 12px;">
                            <thead>                            
                                <tr>
                                    <th data-orderable="false">SN</th>
                                    <th data-orderable="false">Customer Name</th>
                                    <th data-orderable="false">Mobile Number</th>
                                    <th data-orderable="false">Address</th>
                                    <th data-orderable="false">City</th>
                                    <th data-orderable="false">Meeting Date</th>
                                    <th data-orderable="false">Add Date</th>
                                    <th data-orderable="false">Status</th> 
                                    <th data-orderable="false">Action</th> 
                                </tr>
                            </thead>                                
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div id="teleleadstatus_modalid" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <!--<h4 class="modal-title">Modal Header</h4>-->
            </div>
            <div class="modal-body">
                <form class="forms-sample row" action="" id="leadstatustelecaller_formid" method="post">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="followUpDate">Status</label>
                            <select name="leadch_status" readonly="" onmousedown="(function (e) {
                                        e.preventDefault();
                                    })(event, this)" id="leadch_status" class="form-control">
                                <option value="11">Follow-up</option>
                                <option value="12">Not Interested</option>
                                <option value="13">Meeting Schedule & Transfer to Sales Executive</option>
                                <option value="15">Site Survey</option>
                                <option value="16">Solar Design</option>
                                <option value="17">Preparing Proposal</option>
                                <option value="18">Receive Work Order</option>
                                <option value="19">Installer & Incharge Assign</option>
                                <option value="20">Delivering Material</option>
                                <option value="21">Installation</option>
                                <option value="22">Site Inspection</option>
                                <option value="23">Net Metering</option>
                                <option value="24">Handing Over Certificate</option>
                                <option value="25">Compiling and filing all the papers</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-12" style="display: none;" id="assignsalehead_divid">
                        <div class="form-group">
                            <label for="assignedSalesExecutive">Assign Sales Executive</label>
                            <select id="assign_sales_executive" name="assign_sales_executive" class="form-control">
                                <?php
                                while ($row_salesexecutive = mysqli_fetch_array($result_salesexecutive)) {
                                    ?>
                                    <option value="<?php echo $row_salesexecutive['staff_id']; ?>"><?php echo $row_salesexecutive['staff_name']; ?></option>
                                    <?php
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-12" id="followup_divid">
                        <div class="form-group">
                            <label for="followUpDate" id="followup_labelid">Follow-up Date</label>
                            <input type="date" id="followup_date" name="followup_date" class="form-control clrfield">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <label for="address">Notes</label>
                            <input type="text" id="notes" name="notes" class="form-control clrfield" placeholder="Enter Notes">
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <input type="hidden" name="hidden_leadid" id="hidden_leadid" class="form-control" value="">
                            <a class="login-btn btn btn btn-danger profile-save-btn" id="processing_divid" style="display: none;">Processing...</a>
                            <input type="submit" class="btn btn-primary mb-2" id="statuschange_btnid" name="statuschange_btnid" value="Save">
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<button type="button" style="display: none;" id="teleleadstatus_btnid" class="btn btn-info btn-lg" data-toggle="modal" data-target="#teleleadstatus_modalid">Open Modal</button>
<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include '../masters/sext-master.php';
?>

<script type="text/javascript" language="javascript" >

    $(document).ready(function () {
        AdminLeadsListing();
        function AdminLeadsListing() {
            var dataTable = $('#tbladminList').DataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                'ajax': {
                    'url': 'lead-add.inc.php?action=show_leadlist',
                    "type": "POST",
                    "data": function (d) {
                        d.form = JSON.stringify($("#frmFilter").serializeArray());
                    }
                },
                'columns': [
                    {data: 'sno'},
                    {data: 'customer_name'},
                    {data: 'mobile_number'},
                    {data: 'address'},
                    {data: 'city'},
                    {data: 'followup_date'},
                    {data: 'added_date'},
                    {data: 'status'},
                    {data: 'action'}
                ],
                columnDefs: [
                    {className: 'text-center', targets: [0]}
                ],
                "lengthMenu": [500, 1000, 10000],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'Lead List',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5, 6]
                        }
                    }
                ]
            }
            );
        }
    });

    function FilterApplicantList() {
        $('#tbladminList').DataTable().ajax.reload();
    }

    function TelecallerLeadStatusChange(lead_id, leadstatus) {
        $('#hidden_leadid').val(lead_id);
        $('#leadch_status').val(leadstatus);
        if (leadstatus == '11') {
            $('#followup_labelid').html('Follow-up Date');
            $('#assignsalehead_divid').hide();
            $('#followup_divid').show();
        } else if (leadstatus == '12') {
            $('#followup_divid').hide();
            $('#assignsalehead_divid').hide();
        } else if (leadstatus == '13') {
            $('#followup_labelid').html('Meeting Date');
            $('#followup_divid').show();
            $('#assignsalehead_divid').show();
        }
        $('#teleleadstatus_btnid').click();
    }
</script>