<?php
ob_start();
include_once './manage-category.inc.php';
$page_name_info = "manage_category";
?>
<style type="text/css">
    .form-control, .asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=text], .jsgrid .jsgrid-table .jsgrid-filter-row select, .jsgrid .jsgrid-table .jsgrid-filter-row input[type=number], .select2-container--default .select2-selection--single, .select2-container--default .select2-selection--single .select2-search__field, .typeahead, .tt-query, .tt-hint {
        border: 1px solid #2c2e33;
        height: calc(2.25rem + 2px);
        font-weight: normal;
        font-size: 0.875rem;
        padding: 0.625rem 0.6875rem;
        background-color: #2A3038;
        border-radius: 2px;
        color: #000;
    }
    select.form-control, select.asColorPicker-input, .dataTables_wrapper select, .jsgrid .jsgrid-table .jsgrid-filter-row select, .select2-container--default select.select2-selection--single, .select2-container--default .select2-selection--single select.select2-search__field, select.typeahead, select.tt-query, select.tt-hint {
        padding: .4375rem .75rem;
        border: 0;
        color: #000 !important;
    }
</style>
<div class="content-wrapper" style="background: #fff;">
    <div class="page-header">
        <h3 class="page-title" style="color:#000;"> Manage Category </h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="">Category</a></li>
                <li class="breadcrumb-item active" aria-current="page">Manage Category</li>
            </ol>
        </nav>
    </div>
    <div class="row">
        <div class="col-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Add Category</h4>
                    <form class="forms-sample row" action="" id="categoryadd_formid" method="post">
                        <div class="col-12 " id="signup_successmsgid" style="display: none;">
                            <div class="clearfix"></div><br/>
                            <div class="alert alert-success text-center" style="margin-bottom: 0px;">Category Successfully Saved</div>
                            <div class="clearfix"></div><br/>
                        </div>
                        <div class="col-2"></div>
                        <div class="col-6">
                            <div class="form-group">
                                <label>Category Name</label>
                                <div>
                                    <input type="text" name="category_name" id="category_name" autocomplete="category_name" class="form-control clrfield" value="<?php echo common::StrFromDb($row_memberdetails['category_name']); ?>" style="background-color: #fafdf4;"> 
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div>
                                    <input type="hidden" name="hidden_categoryid" id="hidden_categoryid" class="form-control clrfield" value="<?php echo common::StrFromDb($category_id); ?>">
                                    <a class="login-btn btn btn btn-danger profile-save-btn" id="processing_divid" style="display: none;">Processing...</a>
                                    <input type="submit" class="btn btn-primary mb-2" id="register_btnid" name="register_btnid" value="Save" style="    width: 50%;
                                           height: 39px;">
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <h4 style="color:#000;">
        Category Listing
        <div class="clearfix"></div>
    </h4>
    <div class="row">
        <div class="col-lg-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="tbladminList" class="table table-striped dataTable table-hover table-bordered table-condensed" style="font-size: 12px;">
                            <thead>                            
                                <tr>
                                    <th data-orderable="false">SN</th>
                                    <th data-orderable="false">Category</th>
                                    <th data-orderable="false">Action</th>  
                                </tr>
                            </thead>                                
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$mainpagecontent = ob_get_contents();
ob_clean();
include '../masters/admin-master.php';
?>

<script type="text/javascript" language="javascript" >

    $(document).ready(function () {
        AdminCategoryListing();
        function AdminCategoryListing() {
            var dataTable = $('#tbladminList').DataTable({
                'processing': true,
                'serverSide': true,
                'serverMethod': 'post',
                'ajax': {
                    'url': 'manage-category.inc.php?action=show_categorylist',
                    "type": "POST",
                    "data": function (d) {
                        d.form = JSON.stringify($("#frmFilter").serializeArray());
                    }
                },
                'columns': [
                    {data: 'sno'},
                    {data: 'category_name'},
                    {data: 'action'}
                ],
                columnDefs: [
                    {className: 'text-center', targets: [0]}
                ],
                "lengthMenu": [500, 1000, 10000],
                dom: 'lBfrtip',
                buttons: [
                    {
                        extend: 'excelHtml5',
                        title: 'Staff List',
                        exportOptions: {
                            columns: [0, 1, 2]
                        }
                    }
                ]
            }
            );
        }
    });

    function FilterApplicantList() {
        $('#tbladminList').DataTable().ajax.reload();
    }

    function AdminCategoryStatusChange(category_id, status) {
        if (confirm("Are you sure you want to perform this action?")) {
            $.ajax({
                type: "POST",
                url: "manage-category.inc.php",
                data: "category_id=" + category_id + "&status=" + status + "&action=active_inactive",
                success: function (data) {
                    alert('Action successfully performed');
                    window.location = 'manage-category.php';
                }
            });
        }
    }
</script>